<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2026 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\Route66\Administrator\Crawler;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Psr\Http\Message\UriInterface;
use Spatie\Crawler\CrawlProfiles\CrawlInternalUrls;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class Profile extends CrawlInternalUrls
{
    protected array $excludedMenuItems;

    public function __construct($baseUrl)
    {
        parent::__construct($baseUrl);

        $this->excludedMenuItems = $this->getExcludedMenuItems();
    }

    private function getExcludedMenuItems()
    {
        $params = ComponentHelper::getParams('com_route66');

        $exclusions = $params->get('crawler_exclusions', []);

        if (!\count($exclusions)) {
            return [];
        }

        $menu = Factory::getApplication()->getMenu('site');
        $menu->load();

        return $menu->getItems(['id'], $exclusions);
    }

    public function shouldCrawl(UriInterface $url): bool
    {
        if (!parent::shouldCrawl($url)) {
            return false;
        }

        if (!\count($this->excludedMenuItems)) {
            return true;
        }

        $path  = $url->getPath();
        $start = str_starts_with($path, '/index.php/') ? 11 : 1;
        $path  = substr($path, $start);

        if (!$path) {
            return true;
        }

        foreach ($this->excludedMenuItems as $excludedMenuItem) {
            if (str_starts_with($path, $excludedMenuItem->route)) {
                return false;
            }
        }

        return true;
    }
}
