function Readability(e,t){if(t&&t.documentElement)e=t,t=arguments[2];else if(!e||!e.documentElement)throw new Error("First argument to Readability constructor should be a document object.");if(t=t||{},this._doc=e,this._docJSDOMParser=this._doc.firstChild.__JSDOMParser__,this._articleTitle=null,this._articleByline=null,this._articleDir=null,this._articleSiteName=null,this._attempts=[],this._metadata={},this._debug=!!t.debug,this._maxElemsToParse=t.maxElemsToParse||this.DEFAULT_MAX_ELEMS_TO_PARSE,this._nbTopCandidates=t.nbTopCandidates||this.DEFAULT_N_TOP_CANDIDATES,this._charThreshold=t.charThreshold||this.DEFAULT_CHAR_THRESHOLD,this._classesToPreserve=this.CLASSES_TO_PRESERVE.concat(t.classesToPreserve||[]),this._keepClasses=!!t.keepClasses,this._serializer=t.serializer||function(e){return e.innerHTML},this._disableJSONLD=!!t.disableJSONLD,this._allowedVideoRegex=t.allowedVideoRegex||this.REGEXPS.videos,this._linkDensityModifier=t.linkDensityModifier||0,this._flags=this.FLAG_STRIP_UNLIKELYS|this.FLAG_WEIGHT_CLASSES|this.FLAG_CLEAN_CONDITIONALLY,this._debug){let e=function(e){if(e.nodeType==e.TEXT_NODE)return`${e.nodeName} ("${e.textContent}")`;let t=Array.from(e.attributes||[],(function(e){return`${e.name}="${e.value}"`})).join(" ");return`<${e.localName} ${t}>`};this.log=function(){if("undefined"!=typeof console){let t=Array.from(arguments,(t=>t&&t.nodeType==this.ELEMENT_NODE?e(t):t));t.unshift("Reader: (Readability)"),console.log(...t)}else if("undefined"!=typeof dump){var t=Array.prototype.map.call(arguments,(function(t){return t&&t.nodeName?e(t):t})).join(" ");dump("Reader: (Readability) "+t+"\n")}}}else this.log=function(){}}Readability.prototype={FLAG_STRIP_UNLIKELYS:1,FLAG_WEIGHT_CLASSES:2,FLAG_CLEAN_CONDITIONALLY:4,ELEMENT_NODE:1,TEXT_NODE:3,DEFAULT_MAX_ELEMS_TO_PARSE:0,DEFAULT_N_TOP_CANDIDATES:5,DEFAULT_TAGS_TO_SCORE:"section,h2,h3,h4,h5,h6,p,td,pre".toUpperCase().split(","),DEFAULT_CHAR_THRESHOLD:500,REGEXPS:{unlikelyCandidates:/-ad-|ai2html|banner|breadcrumbs|combx|comment|community|cover-wrap|disqus|extra|footer|gdpr|header|legends|menu|related|remark|replies|rss|shoutbox|sidebar|skyscraper|social|sponsor|supplemental|ad-break|agegate|pagination|pager|popup|yom-remote/i,okMaybeItsACandidate:/and|article|body|column|content|main|mathjax|shadow/i,positive:/article|body|content|entry|hentry|h-entry|main|page|pagination|post|text|blog|story/i,negative:/-ad-|hidden|^hid$| hid$| hid |^hid |banner|combx|comment|com-|contact|footer|gdpr|masthead|media|meta|outbrain|promo|related|scroll|share|shoutbox|sidebar|skyscraper|sponsor|shopping|tags|widget/i,extraneous:/print|archive|comment|discuss|e[\-]?mail|share|reply|all|login|sign|single|utility/i,byline:/byline|author|dateline|writtenby|p-author/i,replaceFonts:/<(\/?)font[^>]*>/gi,normalize:/\s{2,}/g,videos:/\/\/(www\.)?((dailymotion|youtube|youtube-nocookie|player\.vimeo|v\.qq|bilibili|live.bilibili)\.com|(archive|upload\.wikimedia)\.org|player\.twitch\.tv)/i,shareElements:/(\b|_)(share|sharedaddy)(\b|_)/i,nextLink:/(next|weiter|continue|>([^\|]|$)|»([^\|]|$))/i,prevLink:/(prev|earl|old|new|<|«)/i,tokenize:/\W+/g,whitespace:/^\s*$/,hasContent:/\S$/,hashUrl:/^#.+/,srcsetUrl:/(\S+)(\s+[\d.]+[xw])?(\s*(?:,|$))/g,b64DataUrl:/^data:\s*([^\s;,]+)\s*;\s*base64\s*,/i,commas:/\u002C|\u060C|\uFE50|\uFE10|\uFE11|\u2E41|\u2E34|\u2E32|\uFF0C/g,jsonLdArticleTypes:/^Article|AdvertiserContentArticle|NewsArticle|AnalysisNewsArticle|AskPublicNewsArticle|BackgroundNewsArticle|OpinionNewsArticle|ReportageNewsArticle|ReviewNewsArticle|Report|SatiricalArticle|ScholarlyArticle|MedicalScholarlyArticle|SocialMediaPosting|BlogPosting|LiveBlogPosting|DiscussionForumPosting|TechArticle|APIReference$/,adWords:/^(ad(vertising|vertisement)?|pub(licité)?|werb(ung)?|广告|Реклама|Anuncio)$/iu,loadingWords:/^((loading|正在加载|Загрузка|chargement|cargando)(…|\.\.\.)?)$/iu},UNLIKELY_ROLES:["menu","menubar","complementary","navigation","alert","alertdialog","dialog"],DIV_TO_P_ELEMS:new Set(["BLOCKQUOTE","DL","DIV","IMG","OL","P","PRE","TABLE","UL"]),ALTER_TO_DIV_EXCEPTIONS:["DIV","ARTICLE","SECTION","P","OL","UL"],PRESENTATIONAL_ATTRIBUTES:["align","background","bgcolor","border","cellpadding","cellspacing","frame","hspace","rules","style","valign","vspace"],DEPRECATED_SIZE_ATTRIBUTE_ELEMS:["TABLE","TH","TD","HR","PRE"],PHRASING_ELEMS:["ABBR","AUDIO","B","BDO","BR","BUTTON","CITE","CODE","DATA","DATALIST","DFN","EM","EMBED","I","IMG","INPUT","KBD","LABEL","MARK","MATH","METER","NOSCRIPT","OBJECT","OUTPUT","PROGRESS","Q","RUBY","SAMP","SCRIPT","SELECT","SMALL","SPAN","STRONG","SUB","SUP","TEXTAREA","TIME","VAR","WBR"],CLASSES_TO_PRESERVE:["page"],HTML_ESCAPE_MAP:{lt:"<",gt:">",amp:"&",quot:'"',apos:"'"},_postProcessContent(e){this._fixRelativeUris(e),this._simplifyNestedElements(e),this._keepClasses||this._cleanClasses(e)},_removeNodes(e,t){if(this._docJSDOMParser&&e._isLiveNodeList)throw new Error("Do not pass live node lists to _removeNodes");for(var i=e.length-1;i>=0;i--){var a=e[i],r=a.parentNode;r&&(t&&!t.call(this,a,i,e)||r.removeChild(a))}},_replaceNodeTags(e,t){if(this._docJSDOMParser&&e._isLiveNodeList)throw new Error("Do not pass live node lists to _replaceNodeTags");for(const i of e)this._setNodeTag(i,t)},_forEachNode(e,t){Array.prototype.forEach.call(e,t,this)},_findNode(e,t){return Array.prototype.find.call(e,t,this)},_someNode(e,t){return Array.prototype.some.call(e,t,this)},_everyNode(e,t){return Array.prototype.every.call(e,t,this)},_getAllNodesWithTag:(e,t)=>e.querySelectorAll?e.querySelectorAll(t.join(",")):[].concat.apply([],t.map((function(t){var i=e.getElementsByTagName(t);return Array.isArray(i)?i:Array.from(i)}))),_cleanClasses(e){var t=this._classesToPreserve,i=(e.getAttribute("class")||"").split(/\s+/).filter((e=>t.includes(e))).join(" ");for(i?e.setAttribute("class",i):e.removeAttribute("class"),e=e.firstElementChild;e;e=e.nextElementSibling)this._cleanClasses(e)},_isUrl(e){try{return new URL(e),!0}catch{return!1}},_fixRelativeUris(e){var t=this._doc.baseURI,i=this._doc.documentURI;function a(e){if(t==i&&"#"==e.charAt(0))return e;try{return new URL(e,t).href}catch(e){}return e}var r=this._getAllNodesWithTag(e,["a"]);this._forEachNode(r,(function(e){var t=e.getAttribute("href");if(t)if(0===t.indexOf("javascript:"))if(1===e.childNodes.length&&e.childNodes[0].nodeType===this.TEXT_NODE){var i=this._doc.createTextNode(e.textContent);e.parentNode.replaceChild(i,e)}else{for(var r=this._doc.createElement("span");e.firstChild;)r.appendChild(e.firstChild);e.parentNode.replaceChild(r,e)}else e.setAttribute("href",a(t))}));var s=this._getAllNodesWithTag(e,["img","picture","figure","video","audio","source"]);this._forEachNode(s,(function(e){var t=e.getAttribute("src"),i=e.getAttribute("poster"),r=e.getAttribute("srcset");if(t&&e.setAttribute("src",a(t)),i&&e.setAttribute("poster",a(i)),r){var s=r.replace(this.REGEXPS.srcsetUrl,(function(e,t,i,r){return a(t)+(i||"")+r}));e.setAttribute("srcset",s)}}))},_simplifyNestedElements(e){for(var t=e;t;){if(t.parentNode&&["DIV","SECTION"].includes(t.tagName)&&(!t.id||!t.id.startsWith("readability"))){if(this._isElementWithoutContent(t)){t=this._removeAndGetNext(t);continue}if(this._hasSingleTagInsideElement(t,"DIV")||this._hasSingleTagInsideElement(t,"SECTION")){for(var i=t.children[0],a=0;a<t.attributes.length;a++)i.setAttributeNode(t.attributes[a].cloneNode());t.parentNode.replaceChild(i,t),t=i;continue}}t=this._getNextNode(t)}},_getArticleTitle(){var e=this._doc,t="",i="";try{"string"!=typeof(t=i=e.title.trim())&&(t=i=this._getInnerText(e.getElementsByTagName("title")[0]))}catch(e){}var a=!1;function r(e){return e.split(/\s+/).length}const s=/\|\-–—\\\/>»/.source;if(new RegExp(`\\s[${s}]\\s`).test(t)){a=/\s[\\\/>»]\s/.test(t);let e=Array.from(i.matchAll(new RegExp(`\\s[${s}]\\s`,"gi")));r(t=i.substring(0,e.pop().index))<3&&(t=i.replace(new RegExp(`^[^${s}]*[${s}]`,"gi"),""))}else if(t.includes(": ")){var n=this._getAllNodesWithTag(e,["h1","h2"]),l=t.trim();this._someNode(n,(function(e){return e.textContent.trim()===l}))||(r(t=i.substring(i.lastIndexOf(":")+1))<3?t=i.substring(i.indexOf(":")+1):r(i.substr(0,i.indexOf(":")))>5&&(t=i))}else if(t.length>150||t.length<15){var o=e.getElementsByTagName("h1");1===o.length&&(t=this._getInnerText(o[0]))}var h=r(t=t.trim().replace(this.REGEXPS.normalize," "));return h<=4&&(!a||h!=r(i.replace(new RegExp(`\\s[${s}]\\s`,"g"),""))-1)&&(t=i),t},_prepDocument(){var e=this._doc;this._removeNodes(this._getAllNodesWithTag(e,["style"])),e.body&&this._replaceBrs(e.body),this._replaceNodeTags(this._getAllNodesWithTag(e,["font"]),"SPAN")},_nextNode(e){for(var t=e;t&&t.nodeType!=this.ELEMENT_NODE&&this.REGEXPS.whitespace.test(t.textContent);)t=t.nextSibling;return t},_replaceBrs(e){this._forEachNode(this._getAllNodesWithTag(e,["br"]),(function(e){for(var t=e.nextSibling,i=!1;(t=this._nextNode(t))&&"BR"==t.tagName;){i=!0;var a=t.nextSibling;t.remove(),t=a}if(i){var r=this._doc.createElement("p");for(e.parentNode.replaceChild(r,e),t=r.nextSibling;t;){if("BR"==t.tagName){var s=this._nextNode(t.nextSibling);if(s&&"BR"==s.tagName)break}if(!this._isPhrasingContent(t))break;var n=t.nextSibling;r.appendChild(t),t=n}for(;r.lastChild&&this._isWhitespace(r.lastChild);)r.lastChild.remove();"P"===r.parentNode.tagName&&this._setNodeTag(r.parentNode,"DIV")}}))},_setNodeTag(e,t){if(this.log("_setNodeTag",e,t),this._docJSDOMParser)return e.localName=t.toLowerCase(),e.tagName=t.toUpperCase(),e;for(var i=e.ownerDocument.createElement(t);e.firstChild;)i.appendChild(e.firstChild);e.parentNode.replaceChild(i,e),e.readability&&(i.readability=e.readability);for(var a=0;a<e.attributes.length;a++)i.setAttributeNode(e.attributes[a].cloneNode());return i},_prepArticle(e){this._cleanStyles(e),this._markDataTables(e),this._fixLazyImages(e),this._cleanConditionally(e,"form"),this._cleanConditionally(e,"fieldset"),this._clean(e,"object"),this._clean(e,"embed"),this._clean(e,"footer"),this._clean(e,"link"),this._clean(e,"aside");var t=this.DEFAULT_CHAR_THRESHOLD;this._forEachNode(e.children,(function(e){this._cleanMatchedNodes(e,(function(e,i){return this.REGEXPS.shareElements.test(i)&&e.textContent.length<t}))})),this._clean(e,"iframe"),this._clean(e,"input"),this._clean(e,"textarea"),this._clean(e,"select"),this._clean(e,"button"),this._cleanHeaders(e),this._cleanConditionally(e,"table"),this._cleanConditionally(e,"ul"),this._cleanConditionally(e,"div"),this._replaceNodeTags(this._getAllNodesWithTag(e,["h1"]),"h2"),this._removeNodes(this._getAllNodesWithTag(e,["p"]),(function(e){return 0===this._getAllNodesWithTag(e,["img","embed","object","iframe"]).length&&!this._getInnerText(e,!1)})),this._forEachNode(this._getAllNodesWithTag(e,["br"]),(function(e){var t=this._nextNode(e.nextSibling);t&&"P"==t.tagName&&e.remove()})),this._forEachNode(this._getAllNodesWithTag(e,["table"]),(function(e){var t=this._hasSingleTagInsideElement(e,"TBODY")?e.firstElementChild:e;if(this._hasSingleTagInsideElement(t,"TR")){var i=t.firstElementChild;if(this._hasSingleTagInsideElement(i,"TD")){var a=i.firstElementChild;a=this._setNodeTag(a,this._everyNode(a.childNodes,this._isPhrasingContent)?"P":"DIV"),e.parentNode.replaceChild(a,e)}}}))},_initializeNode(e){switch(e.readability={contentScore:0},e.tagName){case"DIV":e.readability.contentScore+=5;break;case"PRE":case"TD":case"BLOCKQUOTE":e.readability.contentScore+=3;break;case"ADDRESS":case"OL":case"UL":case"DL":case"DD":case"DT":case"LI":case"FORM":e.readability.contentScore-=3;break;case"H1":case"H2":case"H3":case"H4":case"H5":case"H6":case"TH":e.readability.contentScore-=5}e.readability.contentScore+=this._getClassWeight(e)},_removeAndGetNext(e){var t=this._getNextNode(e,!0);return e.remove(),t},_getNextNode(e,t){if(!t&&e.firstElementChild)return e.firstElementChild;if(e.nextElementSibling)return e.nextElementSibling;do{e=e.parentNode}while(e&&!e.nextElementSibling);return e&&e.nextElementSibling},_textSimilarity(e,t){var i=e.toLowerCase().split(this.REGEXPS.tokenize).filter(Boolean),a=t.toLowerCase().split(this.REGEXPS.tokenize).filter(Boolean);return i.length&&a.length?1-a.filter((e=>!i.includes(e))).join(" ").length/a.join(" ").length:0},_isValidByline(e,t){var i=e.getAttribute("rel"),a=e.getAttribute("itemprop"),r=e.textContent.trim().length;return("author"===i||a&&a.includes("author")||this.REGEXPS.byline.test(t))&&!!r&&r<100},_getNodeAncestors(e,t){t=t||0;for(var i=0,a=[];e.parentNode&&(a.push(e.parentNode),!t||++i!==t);)e=e.parentNode;return a},_grabArticle(e){this.log("**** grabArticle ****");var t=this._doc,i=null!==e;if(!(e=e||this._doc.body))return this.log("No body found in document. Abort."),null;for(var a=e.innerHTML;;){this.log("Starting grabArticle loop");var r=this._flagIsActive(this.FLAG_STRIP_UNLIKELYS),s=[],n=this._doc.documentElement;let J=!0;for(;n;){"HTML"===n.tagName&&(this._articleLang=n.getAttribute("lang"));var l=n.className+" "+n.id;if(this._isProbablyVisible(n))if("true"!=n.getAttribute("aria-modal")||"dialog"!=n.getAttribute("role"))if(this._articleByline||this._metadata.byline||!this._isValidByline(n,l))if(J&&this._headerDuplicatesTitle(n))this.log("Removing header: ",n.textContent.trim(),this._articleTitle.trim()),J=!1,n=this._removeAndGetNext(n);else{if(r){if(this.REGEXPS.unlikelyCandidates.test(l)&&!this.REGEXPS.okMaybeItsACandidate.test(l)&&!this._hasAncestorTag(n,"table")&&!this._hasAncestorTag(n,"code")&&"BODY"!==n.tagName&&"A"!==n.tagName){this.log("Removing unlikely candidate - "+l),n=this._removeAndGetNext(n);continue}if(this.UNLIKELY_ROLES.includes(n.getAttribute("role"))){this.log("Removing content with role "+n.getAttribute("role")+" - "+l),n=this._removeAndGetNext(n);continue}}if("DIV"!==n.tagName&&"SECTION"!==n.tagName&&"HEADER"!==n.tagName&&"H1"!==n.tagName&&"H2"!==n.tagName&&"H3"!==n.tagName&&"H4"!==n.tagName&&"H5"!==n.tagName&&"H6"!==n.tagName||!this._isElementWithoutContent(n)){if(this.DEFAULT_TAGS_TO_SCORE.includes(n.tagName)&&s.push(n),"DIV"===n.tagName){for(var o=null,h=n.firstChild;h;){var d=h.nextSibling;if(this._isPhrasingContent(h))null!==o?o.appendChild(h):this._isWhitespace(h)||(o=t.createElement("p"),n.replaceChild(o,h),o.appendChild(h));else if(null!==o){for(;o.lastChild&&this._isWhitespace(o.lastChild);)o.lastChild.remove();o=null}h=d}if(this._hasSingleTagInsideElement(n,"P")&&this._getLinkDensity(n)<.25){var c=n.children[0];n.parentNode.replaceChild(c,n),n=c,s.push(n)}else this._hasChildBlockElement(n)||(n=this._setNodeTag(n,"P"),s.push(n))}n=this._getNextNode(n)}else n=this._removeAndGetNext(n)}else{for(var g=this._getNextNode(n,!0),_=this._getNextNode(n),m=null;_&&_!=g;){var u=_.getAttribute("itemprop");if(u&&u.includes("name")){m=_;break}_=this._getNextNode(_)}this._articleByline=(m??n).textContent.trim(),n=this._removeAndGetNext(n)}else n=this._removeAndGetNext(n);else this.log("Removing hidden node - "+l),n=this._removeAndGetNext(n)}var p=[];this._forEachNode(s,(function(e){if(e.parentNode&&void 0!==e.parentNode.tagName){var t=this._getInnerText(e);if(!(t.length<25)){var i=this._getNodeAncestors(e,5);if(0!==i.length){var a=0;a+=1,a+=t.split(this.REGEXPS.commas).length,a+=Math.min(Math.floor(t.length/100),3),this._forEachNode(i,(function(e,t){if(e.tagName&&e.parentNode&&void 0!==e.parentNode.tagName){if(void 0===e.readability&&(this._initializeNode(e),p.push(e)),0===t)var i=1;else i=1===t?2:3*t;e.readability.contentScore+=a/i}}))}}}}));for(var N=[],f=0,E=p.length;f<E;f+=1){var b=p[f],T=b.readability.contentScore*(1-this._getLinkDensity(b));b.readability.contentScore=T,this.log("Candidate:",b,"with score "+T);for(var y=0;y<this._nbTopCandidates;y++){var A=N[y];if(!A||T>A.readability.contentScore){N.splice(y,0,b),N.length>this._nbTopCandidates&&N.pop();break}}}var v,S=N[0]||null,C=!1;if(null===S||"BODY"===S.tagName){for(S=t.createElement("DIV"),C=!0;e.firstChild;)this.log("Moving child out:",e.firstChild),S.appendChild(e.firstChild);e.appendChild(S),this._initializeNode(S)}else if(S){for(var L=[],x=1;x<N.length;x++)N[x].readability.contentScore/S.readability.contentScore>=.75&&L.push(this._getNodeAncestors(N[x]));if(L.length>=3)for(v=S.parentNode;"BODY"!==v.tagName;){for(var D=0,I=0;I<L.length&&D<3;I++)D+=Number(L[I].includes(v));if(D>=3){S=v;break}v=v.parentNode}S.readability||this._initializeNode(S),v=S.parentNode;for(var R=S.readability.contentScore,P=R/3;"BODY"!==v.tagName;)if(v.readability){var w=v.readability.contentScore;if(w<P)break;if(w>R){S=v;break}R=v.readability.contentScore,v=v.parentNode}else v=v.parentNode;for(v=S.parentNode;"BODY"!=v.tagName&&1==v.children.length;)v=(S=v).parentNode;S.readability||this._initializeNode(S)}var O=t.createElement("DIV");i&&(O.id="readability-content");for(var B=Math.max(10,.2*S.readability.contentScore),G=(v=S.parentNode).children,M=0,H=G.length;M<H;M++){var k=G[M],U=!1;if(this.log("Looking at sibling node:",k,k.readability?"with score "+k.readability.contentScore:""),this.log("Sibling has score",k.readability?k.readability.contentScore:"Unknown"),k===S)U=!0;else{var W=0;if(k.className===S.className&&""!==S.className&&(W+=.2*S.readability.contentScore),k.readability&&k.readability.contentScore+W>=B)U=!0;else if("P"===k.nodeName){var $=this._getLinkDensity(k),F=this._getInnerText(k),X=F.length;(X>80&&$<.25||X<80&&X>0&&0===$&&-1!==F.search(/\.( |$)/))&&(U=!0)}}U&&(this.log("Appending node:",k),this.ALTER_TO_DIV_EXCEPTIONS.includes(k.nodeName)||(this.log("Altering sibling:",k,"to div."),k=this._setNodeTag(k,"DIV")),O.appendChild(k),G=v.children,M-=1,H-=1)}if(this._debug&&this.log("Article content pre-prep: "+O.innerHTML),this._prepArticle(O),this._debug&&this.log("Article content post-prep: "+O.innerHTML),C)S.id="readability-page-1",S.className="page";else{var j=t.createElement("DIV");for(j.id="readability-page-1",j.className="page";O.firstChild;)j.appendChild(O.firstChild);O.appendChild(j)}this._debug&&this.log("Article content after paging: "+O.innerHTML);var V=!0,Y=this._getInnerText(O,!0).length;if(Y<this._charThreshold)if(V=!1,e.innerHTML=a,this._attempts.push({articleContent:O,textLength:Y}),this._flagIsActive(this.FLAG_STRIP_UNLIKELYS))this._removeFlag(this.FLAG_STRIP_UNLIKELYS);else if(this._flagIsActive(this.FLAG_WEIGHT_CLASSES))this._removeFlag(this.FLAG_WEIGHT_CLASSES);else if(this._flagIsActive(this.FLAG_CLEAN_CONDITIONALLY))this._removeFlag(this.FLAG_CLEAN_CONDITIONALLY);else{if(this._attempts.sort((function(e,t){return t.textLength-e.textLength})),!this._attempts[0].textLength)return null;O=this._attempts[0].articleContent,V=!0}if(V){var z=[v,S].concat(this._getNodeAncestors(v));return this._someNode(z,(function(e){if(!e.tagName)return!1;var t=e.getAttribute("dir");return!!t&&(this._articleDir=t,!0)})),O}}},_unescapeHtmlEntities(e){if(!e)return e;var t=this.HTML_ESCAPE_MAP;return e.replace(/&(quot|amp|apos|lt|gt);/g,(function(e,i){return t[i]})).replace(/&#(?:x([0-9a-f]+)|([0-9]+));/gi,(function(e,t,i){var a=parseInt(t||i,t?16:10);return(0==a||a>1114111||a>=55296&&a<=57343)&&(a=65533),String.fromCodePoint(a)}))},_getJSONLD(e){var t,i=this._getAllNodesWithTag(e,["script"]);return this._forEachNode(i,(function(e){if(!t&&"application/ld+json"===e.getAttribute("type"))try{var i=e.textContent.replace(/^\s*<!\[CDATA\[|\]\]>\s*$/g,""),a=JSON.parse(i);if(Array.isArray(a)&&!(a=a.find((e=>e["@type"]&&e["@type"].match(this.REGEXPS.jsonLdArticleTypes)))))return;var r=/^https?\:\/\/schema\.org\/?$/;if(!("string"==typeof a["@context"]&&a["@context"].match(r)||"object"==typeof a["@context"]&&"string"==typeof a["@context"]["@vocab"]&&a["@context"]["@vocab"].match(r)))return;if(!a["@type"]&&Array.isArray(a["@graph"])&&(a=a["@graph"].find((e=>(e["@type"]||"").match(this.REGEXPS.jsonLdArticleTypes)))),!a||!a["@type"]||!a["@type"].match(this.REGEXPS.jsonLdArticleTypes))return;if(t={},"string"==typeof a.name&&"string"==typeof a.headline&&a.name!==a.headline){var s=this._getArticleTitle(),n=this._textSimilarity(a.name,s)>.75,l=this._textSimilarity(a.headline,s)>.75;t.title=l&&!n?a.headline:a.name}else"string"==typeof a.name?t.title=a.name.trim():"string"==typeof a.headline&&(t.title=a.headline.trim());a.author&&("string"==typeof a.author.name?t.byline=a.author.name.trim():Array.isArray(a.author)&&a.author[0]&&"string"==typeof a.author[0].name&&(t.byline=a.author.filter((function(e){return e&&"string"==typeof e.name})).map((function(e){return e.name.trim()})).join(", "))),"string"==typeof a.description&&(t.excerpt=a.description.trim()),a.publisher&&"string"==typeof a.publisher.name&&(t.siteName=a.publisher.name.trim()),"string"==typeof a.datePublished&&(t.datePublished=a.datePublished.trim())}catch(e){this.log(e.message)}})),t||{}},_getArticleMetadata(e){var t={},i={},a=this._doc.getElementsByTagName("meta"),r=/\s*(article|dc|dcterm|og|twitter)\s*:\s*(author|creator|description|published_time|title|site_name)\s*/gi,s=/^\s*(?:(dc|dcterm|og|twitter|parsely|weibo:(article|webpage))\s*[-\.:]\s*)?(author|creator|pub-date|description|title|site_name)\s*$/i;this._forEachNode(a,(function(e){var t=e.getAttribute("name"),a=e.getAttribute("property"),n=e.getAttribute("content");if(n){var l=null,o=null;a&&(l=a.match(r))&&(o=l[0].toLowerCase().replace(/\s/g,""),i[o]=n.trim()),!l&&t&&s.test(t)&&(o=t,n&&(o=o.toLowerCase().replace(/\s/g,"").replace(/\./g,":"),i[o]=n.trim()))}})),t.title=e.title||i["dc:title"]||i["dcterm:title"]||i["og:title"]||i["weibo:article:title"]||i["weibo:webpage:title"]||i.title||i["twitter:title"]||i["parsely-title"],t.title||(t.title=this._getArticleTitle());const n="string"!=typeof i["article:author"]||this._isUrl(i["article:author"])?void 0:i["article:author"];return t.byline=e.byline||i["dc:creator"]||i["dcterm:creator"]||i.author||i["parsely-author"]||n,t.excerpt=e.excerpt||i["dc:description"]||i["dcterm:description"]||i["og:description"]||i["weibo:article:description"]||i["weibo:webpage:description"]||i.description||i["twitter:description"],t.siteName=e.siteName||i["og:site_name"],t.publishedTime=e.datePublished||i["article:published_time"]||i["parsely-pub-date"]||null,t.title=this._unescapeHtmlEntities(t.title),t.byline=this._unescapeHtmlEntities(t.byline),t.excerpt=this._unescapeHtmlEntities(t.excerpt),t.siteName=this._unescapeHtmlEntities(t.siteName),t.publishedTime=this._unescapeHtmlEntities(t.publishedTime),t},_isSingleImage(e){for(;e;){if("IMG"===e.tagName)return!0;if(1!==e.children.length||""!==e.textContent.trim())return!1;e=e.children[0]}return!1},_unwrapNoscriptImages(e){var t=Array.from(e.getElementsByTagName("img"));this._forEachNode(t,(function(e){for(var t=0;t<e.attributes.length;t++){var i=e.attributes[t];switch(i.name){case"src":case"srcset":case"data-src":case"data-srcset":return}if(/\.(jpg|jpeg|png|webp)/i.test(i.value))return}e.remove()}));var i=Array.from(e.getElementsByTagName("noscript"));this._forEachNode(i,(function(t){if(this._isSingleImage(t)){var i=e.createElement("div");i.innerHTML=t.innerHTML;var a=t.previousElementSibling;if(a&&this._isSingleImage(a)){var r=a;"IMG"!==r.tagName&&(r=a.getElementsByTagName("img")[0]);for(var s=i.getElementsByTagName("img")[0],n=0;n<r.attributes.length;n++){var l=r.attributes[n];if(""!==l.value&&("src"===l.name||"srcset"===l.name||/\.(jpg|jpeg|png|webp)/i.test(l.value))){if(s.getAttribute(l.name)===l.value)continue;var o=l.name;s.hasAttribute(o)&&(o="data-old-"+o),s.setAttribute(o,l.value)}}t.parentNode.replaceChild(i.firstElementChild,a)}}}))},_removeScripts(e){this._removeNodes(this._getAllNodesWithTag(e,["script","noscript"]))},_hasSingleTagInsideElement(e,t){return 1==e.children.length&&e.children[0].tagName===t&&!this._someNode(e.childNodes,(function(e){return e.nodeType===this.TEXT_NODE&&this.REGEXPS.hasContent.test(e.textContent)}))},_isElementWithoutContent(e){return!(e.nodeType!==this.ELEMENT_NODE||e.textContent.trim().length||e.children.length&&e.children.length!=e.getElementsByTagName("br").length+e.getElementsByTagName("hr").length)},_hasChildBlockElement(e){return this._someNode(e.childNodes,(function(e){return this.DIV_TO_P_ELEMS.has(e.tagName)||this._hasChildBlockElement(e)}))},_isPhrasingContent(e){return e.nodeType===this.TEXT_NODE||this.PHRASING_ELEMS.includes(e.tagName)||("A"===e.tagName||"DEL"===e.tagName||"INS"===e.tagName)&&this._everyNode(e.childNodes,this._isPhrasingContent)},_isWhitespace(e){return e.nodeType===this.TEXT_NODE&&0===e.textContent.trim().length||e.nodeType===this.ELEMENT_NODE&&"BR"===e.tagName},_getInnerText(e,t){t=void 0===t||t;var i=e.textContent.trim();return t?i.replace(this.REGEXPS.normalize," "):i},_getCharCount(e,t){return t=t||",",this._getInnerText(e).split(t).length-1},_cleanStyles(e){if(e&&"svg"!==e.tagName.toLowerCase()){for(var t=0;t<this.PRESENTATIONAL_ATTRIBUTES.length;t++)e.removeAttribute(this.PRESENTATIONAL_ATTRIBUTES[t]);this.DEPRECATED_SIZE_ATTRIBUTE_ELEMS.includes(e.tagName)&&(e.removeAttribute("width"),e.removeAttribute("height"));for(var i=e.firstElementChild;null!==i;)this._cleanStyles(i),i=i.nextElementSibling}},_getLinkDensity(e){var t=this._getInnerText(e).length;if(0===t)return 0;var i=0;return this._forEachNode(e.getElementsByTagName("a"),(function(e){var t=e.getAttribute("href"),a=t&&this.REGEXPS.hashUrl.test(t)?.3:1;i+=this._getInnerText(e).length*a})),i/t},_getClassWeight(e){if(!this._flagIsActive(this.FLAG_WEIGHT_CLASSES))return 0;var t=0;return"string"==typeof e.className&&""!==e.className&&(this.REGEXPS.negative.test(e.className)&&(t-=25),this.REGEXPS.positive.test(e.className)&&(t+=25)),"string"==typeof e.id&&""!==e.id&&(this.REGEXPS.negative.test(e.id)&&(t-=25),this.REGEXPS.positive.test(e.id)&&(t+=25)),t},_clean(e,t){var i=["object","embed","iframe"].includes(t);this._removeNodes(this._getAllNodesWithTag(e,[t]),(function(e){if(i){for(var t=0;t<e.attributes.length;t++)if(this._allowedVideoRegex.test(e.attributes[t].value))return!1;if("object"===e.tagName&&this._allowedVideoRegex.test(e.innerHTML))return!1}return!0}))},_hasAncestorTag(e,t,i,a){i=i||3,t=t.toUpperCase();for(var r=0;e.parentNode;){if(i>0&&r>i)return!1;if(e.parentNode.tagName===t&&(!a||a(e.parentNode)))return!0;e=e.parentNode,r++}return!1},_getRowAndColumnCount(e){for(var t=0,i=0,a=e.getElementsByTagName("tr"),r=0;r<a.length;r++){var s=a[r].getAttribute("rowspan")||0;s&&(s=parseInt(s,10)),t+=s||1;for(var n=0,l=a[r].getElementsByTagName("td"),o=0;o<l.length;o++){var h=l[o].getAttribute("colspan")||0;h&&(h=parseInt(h,10)),n+=h||1}i=Math.max(i,n)}return{rows:t,columns:i}},_markDataTables(e){for(var t=e.getElementsByTagName("table"),i=0;i<t.length;i++){var a=t[i];if("presentation"!=a.getAttribute("role"))if("0"!=a.getAttribute("datatable"))if(a.getAttribute("summary"))a._readabilityDataTable=!0;else{var r=a.getElementsByTagName("caption")[0];if(r&&r.childNodes.length)a._readabilityDataTable=!0;else{if(["col","colgroup","tfoot","thead","th"].some((function(e){return!!a.getElementsByTagName(e)[0]})))this.log("Data table because found data-y descendant"),a._readabilityDataTable=!0;else if(a.getElementsByTagName("table")[0])a._readabilityDataTable=!1;else{var s=this._getRowAndColumnCount(a);1!=s.columns&&1!=s.rows?s.rows>=10||s.columns>4?a._readabilityDataTable=!0:a._readabilityDataTable=s.rows*s.columns>10:a._readabilityDataTable=!1}}}else a._readabilityDataTable=!1;else a._readabilityDataTable=!1}},_fixLazyImages(e){this._forEachNode(this._getAllNodesWithTag(e,["img","picture","figure"]),(function(e){if(e.src&&this.REGEXPS.b64DataUrl.test(e.src)){var t=this.REGEXPS.b64DataUrl.exec(e.src);if("image/svg+xml"===t[1])return;for(var i=!1,a=0;a<e.attributes.length;a++){var r=e.attributes[a];if("src"!==r.name&&/\.(jpg|jpeg|png|webp)/i.test(r.value)){i=!0;break}}if(i){var s=t[0].length;e.src.length-s<133&&e.removeAttribute("src")}}if(!(e.src||e.srcset&&"null"!=e.srcset)||e.className.toLowerCase().includes("lazy"))for(var n=0;n<e.attributes.length;n++)if("src"!==(r=e.attributes[n]).name&&"srcset"!==r.name&&"alt"!==r.name){var l=null;if(/\.(jpg|jpeg|png|webp)\s+\d/.test(r.value)?l="srcset":/^\s*\S+\.(jpg|jpeg|png|webp)\S*\s*$/.test(r.value)&&(l="src"),l)if("IMG"===e.tagName||"PICTURE"===e.tagName)e.setAttribute(l,r.value);else if("FIGURE"===e.tagName&&!this._getAllNodesWithTag(e,["img","picture"]).length){var o=this._doc.createElement("img");o.setAttribute(l,r.value),e.appendChild(o)}}}))},_getTextDensity(e,t){var i=this._getInnerText(e,!0).length;if(0===i)return 0;var a=0,r=this._getAllNodesWithTag(e,t);return this._forEachNode(r,(e=>a+=this._getInnerText(e,!0).length)),a/i},_cleanConditionally(e,t){this._flagIsActive(this.FLAG_CLEAN_CONDITIONALLY)&&this._removeNodes(this._getAllNodesWithTag(e,[t]),(function(e){var i=function(e){return e._readabilityDataTable},a="ul"===t||"ol"===t;if(!a){var r=0,s=this._getAllNodesWithTag(e,["ul","ol"]);this._forEachNode(s,(e=>r+=this._getInnerText(e).length)),a=r/this._getInnerText(e).length>.9}if("table"===t&&i(e))return!1;if(this._hasAncestorTag(e,"table",-1,i))return!1;if(this._hasAncestorTag(e,"code"))return!1;if([...e.getElementsByTagName("table")].some((e=>e._readabilityDataTable)))return!1;var n=this._getClassWeight(e);this.log("Cleaning Conditionally",e);if(n+0<0)return!0;if(this._getCharCount(e,",")<10){for(var l=e.getElementsByTagName("p").length,o=e.getElementsByTagName("img").length,h=e.getElementsByTagName("li").length-100,d=e.getElementsByTagName("input").length,c=this._getTextDensity(e,["h1","h2","h3","h4","h5","h6"]),g=0,_=this._getAllNodesWithTag(e,["object","embed","iframe"]),m=0;m<_.length;m++){for(var u=0;u<_[m].attributes.length;u++)if(this._allowedVideoRegex.test(_[m].attributes[u].value))return!1;if("object"===_[m].tagName&&this._allowedVideoRegex.test(_[m].innerHTML))return!1;g++}var p=this._getInnerText(e);if(this.REGEXPS.adWords.test(p)||this.REGEXPS.loadingWords.test(p))return!0;var N=p.length,f=this._getLinkDensity(e),E=["SPAN","LI","TD"].concat(Array.from(this.DIV_TO_P_ELEMS)),b=this._getTextDensity(e,E),T=this._hasAncestorTag(e,"figure");var y=(()=>{const e=[];return!T&&o>1&&l/o<.5&&e.push(`Bad p to img ratio (img=${o}, p=${l})`),!a&&h>l&&e.push(`Too many li's outside of a list. (li=${h} > p=${l})`),d>Math.floor(l/3)&&e.push(`Too many inputs per p. (input=${d}, p=${l})`),!a&&!T&&c<.9&&N<25&&(0===o||o>2)&&f>0&&e.push(`Suspiciously short. (headingDensity=${c}, img=${o}, linkDensity=${f})`),!a&&n<25&&f>.2+this._linkDensityModifier&&e.push(`Low weight and a little linky. (linkDensity=${f})`),n>=25&&f>.5+this._linkDensityModifier&&e.push(`High weight and mostly links. (linkDensity=${f})`),(1===g&&N<75||g>1)&&e.push(`Suspicious embed. (embedCount=${g}, contentLength=${N})`),0===o&&0===b&&e.push(`No useful content. (img=${o}, textDensity=${b})`),!!e.length&&(this.log("Checks failed",e),!0)})();if(a&&y){for(var A=0;A<e.children.length;A++){if(e.children[A].children.length>1)return y}let t=e.getElementsByTagName("li").length;if(o==t)return!1}return y}return!1}))},_cleanMatchedNodes(e,t){for(var i=this._getNextNode(e,!0),a=this._getNextNode(e);a&&a!=i;)a=t.call(this,a,a.className+" "+a.id)?this._removeAndGetNext(a):this._getNextNode(a)},_cleanHeaders(e){let t=this._getAllNodesWithTag(e,["h1","h2"]);this._removeNodes(t,(function(e){let t=this._getClassWeight(e)<0;return t&&this.log("Removing header with low class weight:",e),t}))},_headerDuplicatesTitle(e){if("H1"!=e.tagName&&"H2"!=e.tagName)return!1;var t=this._getInnerText(e,!1);return this.log("Evaluating similarity of header:",t,this._articleTitle),this._textSimilarity(this._articleTitle,t)>.75},_flagIsActive(e){return(this._flags&e)>0},_removeFlag(e){this._flags=this._flags&~e},_isProbablyVisible:e=>(!e.style||"none"!=e.style.display)&&(!e.style||"hidden"!=e.style.visibility)&&!e.hasAttribute("hidden")&&(!e.hasAttribute("aria-hidden")||"true"!=e.getAttribute("aria-hidden")||e.className&&e.className.includes&&e.className.includes("fallback-image")),parse(){if(this._maxElemsToParse>0){var e=this._doc.getElementsByTagName("*").length;if(e>this._maxElemsToParse)throw new Error("Aborting parsing document; "+e+" elements found")}this._unwrapNoscriptImages(this._doc);var t=this._disableJSONLD?{}:this._getJSONLD(this._doc);this._removeScripts(this._doc),this._prepDocument();var i=this._getArticleMetadata(t);this._metadata=i,this._articleTitle=i.title;var a=this._grabArticle();if(!a)return null;if(this.log("Grabbed: "+a.innerHTML),this._postProcessContent(a),!i.excerpt){var r=a.getElementsByTagName("p");r.length&&(i.excerpt=r[0].textContent.trim())}var s=a.textContent;return{title:this._articleTitle,byline:i.byline||this._articleByline,dir:this._articleDir,lang:this._articleLang,content:this._serializer(a),textContent:s,length:s.length,excerpt:i.excerpt,siteName:i.siteName||this._articleSiteName,publishedTime:i.publishedTime}}},"object"==typeof module&&(module.exports=Readability);