<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\Route66\Administrator\AI;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class AnthropicService implements AIServiceInterface
{
    protected string $apiKey;
    protected string $model;
    protected float $temperature;

    public function __construct(string $apiKey, string $model = 'claude-3-haiku-20240307', float $temperature = 0.7)
    {
        $this->apiKey      = $apiKey;
        $this->model       = $model;
        $this->temperature = $temperature;
    }

    public function generate(string $prompt, array $options = []): void
    {
        $endpoint = 'https://api.anthropic.com/v1/messages';

        $body = [
            'model'       => $options['model'] ?? $this->model,
            'temperature' => $options['temperature'] ?? $this->temperature,
            'max_tokens'  => 2048,
            'system'      => $options['instructions'] ?? '',
            'messages'    => [
                [
                    'role'    => 'user',
                    'content' => $prompt,
                ],
            ],
            'stream' => true,
        ];

        $headers =  [
           'x-api-key: ' . $this->apiKey,
           'anthropic-version: 2023-06-01',
           'Content-Type: application/json',
        ];


        $ch = curl_init($endpoint);
        curl_setopt_array($ch, [
            CURLOPT_CONNECTTIMEOUT => 0,
            CURLOPT_TIMEOUT        => 120,
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => json_encode($body),
            CURLOPT_HTTPHEADER     => $headers,
            CURLOPT_RETURNTRANSFER => false,
            CURLOPT_WRITEFUNCTION  => function ($ch, $chunk) {

                $lines = explode("\n", $chunk);

                foreach ($lines as $line) {

                    $line = trim($line);

                    if (str_starts_with($line, 'data: ')) {

                        $json = substr($line, 6);
                        $data = json_decode($json, true);

                        if ($data && isset($data['delta']['text'])) {
                            echo "event: chunk\n";
                            echo "data: " . rtrim($data['delta']['text'], "\r\n") . "\n\n";
                            @ob_flush();
                            @flush();
                        }
                    }
                }

                return \strlen($chunk);
            },
        ]);

        curl_exec($ch);

        if (curl_errno($ch)) {
            throw new \RuntimeException(curl_error($ch));
        }

        curl_close($ch);
    }
}
