<?php
/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2018 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */
defined('_JEXEC') or die;

use Joomla\Registry\Registry;

class PlgContentRoute66Metadata extends JPlugin
{
    protected $autoloadLanguage = true;
    protected $ogMeta = false;

    public function onContentPrepareForm($form, $data)
    {
        if (!($form instanceof JForm)) {
            $this->_subject->setError('JERROR_NOT_A_FORM');
            return false;
        }

        $name = $form->getName();
        $application = JFactory::getApplication();
        if ($name == 'com_content.article' && $application->input->getMethod() == 'GET') {

            // Cast to object
            if (is_array($data)) {
                $data = (object) $data;
            }

            if (!isset($data->route66metadata)) {
                $data->route66metadata = array();
            }

            JForm::addFormPath(JPATH_ADMINISTRATOR.'/components/com_route66/forms');
            $form->loadFile('route66metadata', false);
        }
    }

    public function onContentAfterSave($context, $article, $isNew)
    {
        if ($context == 'com_content.article') {
            $application = JFactory::getApplication();
            $data = $application->input->post->get('jform', array(), 'array');
            if (isset($data['route66metadata']) && is_array($data['route66metadata'])) {
                $resourceId = (int)$article->id;
                JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_route66/models');
                $model = JModelLegacy::getInstance('Metadata', 'Route66Model');
                $model->delete($context, $article->id);
                $model->save($context, $article->id, $data['route66metadata']);
            }
        }
    }

    public function onContentPrepareData($context, $data)
    {
        if($context != 'com_content.article')
        {
          return true;
        }
        $id = is_object($data) ? $data->id: $data['id'];
        if ($id) {
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_route66/models');
            $model = JModelLegacy::getInstance('Metadata', 'Route66Model');
            $result = $model->fetch($context, $id);
            if ($result) {
                $metadata = json_decode($result->metadata);
            } else {
                $metadata = array();
            }
            if(is_object($data))
            {
              $data->route66metadata = $metadata;
            }
            else
            {
              $data['route66metadata'] = $metadata;
            }
        }

        return true;
    }

    public function onContentAfterDelete($context, $data)
    {
        if ($context == 'com_content.article') {
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_route66/models');
            $model = JModelLegacy::getInstance('Metadata', 'Route66Model');
            $model->delete($context, $data->id);
        }

        return true;
    }

    public function onContentAfterDisplay($context, $item, $params, $limitstart = 0)
    {
        if ($context == 'com_content.article') {
            JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_route66/models');
            $model = JModelLegacy::getInstance('Metadata', 'Route66Model');
            $result = $model->fetch($context, $item->id);
            $this->ogMeta = true;
            $this->item = $item;
            if($result)
            {
              $this->data = $result->metadata;
            }
            else
            {
              $this->data = '';
            }
        }
    }

    public function onBeforeCompileHead()
    {
      if($this->ogMeta)
      {
        $metadata = new Registry($this->data);
        $document = JFactory::getDocument();
        if ($metadata->get('og_type', 'article')) {
            $document->setMetadata('og:type', $metadata->get('og_type', 'article'), 'property');
            $document->setMetadata('og:url', JUri::current(), 'property');
            $document->setMetadata('og:title', $metadata->get('og_title', $this->item->title), 'property');
            $document->setMetadata('og:description', $metadata->get('og_description', $document->getDescription()), 'property');
            if ($ogImageType = $metadata->get('og_image', 'full_image')) {
                $image = null;
                $itemImages = json_decode($this->item->images);
                if($ogImageType == 'intro_image' && isset($itemImages->image_intro) && $itemImages->image_intro)
                {
                  $image = JUri::root(false).$itemImages->image_intro;
                }
                else if($ogImageType == 'full_image' && isset($itemImages->image_fulltext) && $itemImages->image_fulltext)
                {
                  $image = JUri::root(false).$itemImages->image_fulltext;
                }
                else if($ogImageType == 'media' && $metadata->get('og_image_media'))
                {
                  $image = JUri::root(false).$metadata->get('og_image_media');
                }
                else if($ogImageType == 'url' && $metadata->get('og_image_url')) {
                  $image = $metadata->get('og_image_url');
                }
                if($image)
                {
                  $document->setMetadata('og:image', $image, 'property');
                }
            }
        }
      }
    }
}
