<?php
/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2017 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */
defined('_JEXEC') or die;

class Route66HelperHtml
{
    public static function getSidebar($view)
    {
        JHtmlSidebar::addEntry(JText::_('COM_ROUTE66_URL_PATTERNS'), 'index.php?option=com_route66&view=urls', $view == 'urls');
        JHtmlSidebar::addEntry(JText::_('COM_ROUTE66_SITEMAPS'), 'index.php?option=com_route66&view=sitemaps', $view == 'sitemaps');
        JHtmlSidebar::addEntry(JText::_('COM_ROUTE66_FACEBOOK_INSTANT_ARTICLES'), 'index.php?option=com_route66&view=instantarticlesfeeds', $view == 'instantarticlesfeeds');
        JHtmlSidebar::setAction('index.php?option=com_route66&view='.$view);

        return JHtmlSidebar::render();
    }

    public static function addOptionsButton()
    {
        $user = JFactory::getUser();
        if ($user->authorise('core.admin', 'com_route66') || $user->authorise('core.options', 'com_route66')) {
            JToolbarHelper::preferences('com_route66');
        }
    }

    public static function copyrights()
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->qn('manifest_cache'))->from($db->qn('#__extensions'))->where($db->qn('element').' = '.$db->q('pkg_route66'));
        $db->setQuery($query);
        $manifest = json_decode($db->loadResult());

        return '<div class="text-center"><a target="_blank" href="https://www.firecoders.com/extensions/route-66">'.$manifest->name.' v'.$manifest->version.'</a> | Copyright &copy; 2016 - 2017 <a target="_blank" href="https://www.firecoders.com">Firecoders</a></div>';
    }
}
