<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Mail\MailTemplate;
use Joomla\CMS\User\UserHelper;

return new class () implements InstallerScriptInterface {
    public function install(InstallerAdapter $adapter): bool
    {
        return true;
    }

    public function update(InstallerAdapter $adapter): bool
    {
        return true;
    }

    public function uninstall(InstallerAdapter $adapter): bool
    {
        return true;
    }

    public function preflight(string $type, InstallerAdapter $adapter): bool
    {
        if (version_compare(JVERSION, '5.4.0', '<')) {
            Factory::getApplication()->enqueueMessage('This version of CommentBox requires Joomla 5.4 or newer', 'error');
            return false;
        }

        return true;
    }

    public function postflight(string $type, InstallerAdapter $adapter): bool
    {
        if ($type === 'install' || $type === 'update') {
            $this->setComponentSecret();
            $this->setEmailTemplates();
            $this->enablePlugins();
        }

        return true;
    }

    private function setComponentSecret()
    {
        $params = ComponentHelper::getParams('com_commentbox');

        if ($params->get('secret')) {
            return;
        }

        $params->set('secret', UserHelper::genRandomPassword(16));

        $db    = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update($db->qn('#__extensions'));
        $query->set($db->qn('params') . ' = '.$db->q($params->toString()));
        $query->where($db->qn('element') . ' = ' . $db->q('com_commentbox'));
        $db->setQuery($query);
        $db->execute();
    }

    private function setEmailTemplates()
    {
        // Add
        $template = MailTemplate::getTemplate('com_commentbox.comment.add', '');
        if (!$template) {
            MailTemplate::createTemplate('com_commentbox.comment.add', 'COM_COMMENTBOX_NOTIFICATION_ADDED_SUBJECT', 'COM_COMMENTBOX_NOTIFICATION_ADDED_BODY', ['PAGE_TITLE', 'RECIPIENT_NAME', 'USER_NAME', 'COMMENT_LINK', 'SITE_NAME']);
        }

        // Approval
        $template = MailTemplate::getTemplate('com_commentbox.comment.publish', '');
        if (!$template) {
            MailTemplate::createTemplate('com_commentbox.comment.publish', 'COM_COMMENTBOX_NOTIFICATION_PUBLISHED_SUBJECT', 'COM_COMMENTBOX_NOTIFICATION_PUBLISHED_BODY', ['PAGE_TITLE', 'RECIPIENT_NAME', 'USER_NAME', 'COMMENT_LINK', 'SITE_NAME']);
        }

        // Reply
        $template = MailTemplate::getTemplate('com_commentbox.comment.reply', '');
        if (!$template) {
            MailTemplate::createTemplate('com_commentbox.comment.reply', 'COM_COMMENTBOX_NOTIFICATION_REPLY_SUBJECT', 'COM_COMMENTBOX_NOTIFICATION_REPLY_BODY', ['PAGE_TITLE', 'RECIPIENT_NAME', 'USER_NAME', 'COMMENT_LINK', 'SITE_NAME']);
        }

        // Flagged
        $template = MailTemplate::getTemplate('com_commentbox.comment.flagged', '');
        if (!$template) {
            MailTemplate::createTemplate('com_commentbox.comment.flagged', 'COM_COMMENTBOX_NOTIFICATION_FLAGGED_SUBJECT', 'COM_COMMENTBOX_NOTIFICATION_FLAGGED_BODY', ['PAGE_TITLE', 'RECIPIENT_NAME', 'USER_NAME', 'COMMENT_LINK', 'SITE_NAME']);
        }

        // Mention
        $template = MailTemplate::getTemplate('com_commentbox.user.mention', '');
        if (!$template) {
            MailTemplate::createTemplate('com_commentbox.user.mention', 'COM_COMMENTBOX_NOTIFICATION_MENTION_SUBJECT', 'COM_COMMENTBOX_NOTIFICATION_MENTION_BODY', ['PAGE_TITLE', 'RECIPIENT_NAME', 'USER_NAME', 'COMMENT_LINK', 'SITE_NAME']);
        }
    }

    private function enablePlugins()
    {
        $db    = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update($db->qn('#__extensions'));
        $query->set($db->qn('enabled') . ' = '.$db->q(1));
        $query->where($db->qn('type') . ' = ' . $db->q('plugin'));
        $query->where('(' . $db->qn('folder') . ' = ' . $db->q('commentbox') . ' OR ' . $db->qn('element') . ' = ' . $db->q('commentbox') . ')');
        $db->setQuery($query);
        $db->execute();
    }
};
