const startCommentBoxCounters = async () => {

    const commentBoxCounters = document.querySelectorAll('.commentbox-counter');

    if (!commentBoxCounters.length) {
        return;
    }

    const urls = [];

    commentBoxCounters.forEach(commentBoxCounter => {
        const url = commentBoxCounter.getAttribute('href');
        urls.push(url);
    });

    if (urls.length === 0) {
        return;
    }

    try {
        const response = await fetch(window.Joomla.getOptions('system.paths').rootFull + 'index.php?option=com_commentbox&task=comments.counters&format=json', {
            method: 'POST',
            body: JSON.stringify({
                urls: urls,
                [window.Joomla.getOptions('csrf.token')]: 1,
            }),
            headers: {
                'Content-Type': 'application/json',
            },
        });

        const data = await response.json();

        data.forEach((item, index) => {
            const commentBoxCounter = commentBoxCounters[index];
            if (commentBoxCounter) {
                let text = ''
                if (item.count === 0) {
                    text = Joomla.Text._('COM_COMMENTBOX_NO_COMMENTS');
                } else if (item.count === 1) {
                    text = Joomla.Text._('COM_COMMENTBOX_ONE_COMMENT');
                } else {
                    text = Joomla.Text._('COM_COMMENTBOX_MULTIPLE_COMMENTS');
                }
                text = text.replace('%d', item.count);
                commentBoxCounter.querySelector('span').innerHTML = text;
            }
        });
    } catch (error) {
        console.error(error);
    }



}


window.addEventListener('DOMContentLoaded', () => {
    startCommentBoxCounters();
});

