const setupExpandButtons = () => {

  const expandButtons = document.querySelectorAll('.commentbox-expand-button');
  expandButtons.forEach((expandButton) => {
    expandButton.classList.add('hidden');
    expandButton.addEventListener('click', (event) => {
      event.preventDefault();
      event.target.parentNode.classList.add('expanded');
    })
  });

  const collapseButtons = document.querySelectorAll('.commentbox-collapse-button');
  collapseButtons.forEach((collapseButton) => {
    collapseButton.classList.add('hidden');
    collapseButton.addEventListener('click', (event) => {
      event.preventDefault();
      event.target.parentNode.classList.remove('expanded');
    })
  });

  const commentTexts = document.querySelectorAll('.commentbox-comment');
  commentTexts.forEach((element) => {
    if (element.querySelector('.commentbox-comment-text').getBoundingClientRect().height === 100) {
      element.querySelectorAll('a.hidden').forEach((link) => {
        link.classList.remove('hidden');
      });
    }
  });

}

const throttle = (callback, delay) => {
  let throttling = false;
  return (...args) => {
    if (!throttling) {
      throttling = true;
      callback(...args);
      setTimeout(() => {
        throttling = false;
      }, delay);
    }
  };
};

window.addEventListener('resize', throttle(setupExpandButtons, 200));
window.addEventListener('load', setupExpandButtons);