<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\View\Users;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\JsonView as BaseJsonView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class JsonView extends BaseJsonView
{
    protected $items = [];
    protected $total = 0;

    public function display($tpl = null)
    {
        $user = Factory::getApplication()->getIdentity();

        if ($user->guest) {
            throw new NotAllowed(Text::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN'), 403);
        }

        $items = $this->get('Items');

        if ($errors = $this->getModel()->getErrors()) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $this->_output = ['items' => $items];

        echo json_encode($this->_output, JSON_UNESCAPED_UNICODE);
    }

}
