<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\View\User;

use Firecoders\Component\CommentBox\Administrator\Helper\UserHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\JsonView as BaseJsonView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class JsonView extends BaseJsonView
{
    public function display($tpl = null)
    {
        $user = Factory::getApplication()->getIdentity();

        $permissions = [
            'add'       => $user->authorise('core.create', 'com_commentbox'),
            'edit'      => $user->authorise('core.edit', 'com_commentbox'),
            'editOwn'   => $user->authorise('core.edit.own', 'com_commentbox'),
            'editState' => $user->authorise('core.edit.state', 'com_commentbox'),
            'trashOwn'  => $user->authorise('core.trash.own', 'com_commentbox'),
            'delete'    => $user->authorise('core.delete', 'com_commentbox'),
            'deleteOwn' => $user->authorise('core.delete.own', 'com_commentbox'),
            'upload'    => $user->authorise('core.upload', 'com_commentbox'),
        ];

        $email  = $user->guest ? '' : $user->email;
        $avatar = UserHelper::getAvatar($email);

        $this->_output = ['permissions' => $permissions, 'guest' => $user->guest, 'avatar' => $avatar];

        echo json_encode($this->_output, JSON_UNESCAPED_UNICODE);
    }

}
