<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\View\Comments;

use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\JsonView as BaseJsonView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class JsonView extends BaseJsonView
{
    protected $items = [];
    protected $total = 0;

    public function display($tpl = null)
    {
        $this->items = $this->get('Tree');
        $this->total = $this->get('Total');

        if ($errors = $this->getModel()->getErrors()) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $this->_output = ['items' => $this->items, 'total' => $this->total];

        echo json_encode($this->_output, JSON_UNESCAPED_UNICODE);
    }

}
