<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\View\Comment;

use Firecoders\Component\CommentBox\Administrator\Helper\CommentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\Exception;
use Joomla\CMS\MVC\View\JsonView as BaseJsonView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class JsonView extends BaseJsonView
{
    protected $item = null;

    public function display($tpl = null)
    {
        $item = $this->get('Item');

        CommentHelper::prepare($item);

        if (!$item) {
            throw new Exception\ResourceNotFound(Text::_('JERROR_PAGE_NOT_FOUND'), 404);
        }

        $this->_output = $item;

        echo json_encode($this->_output, JSON_UNESCAPED_UNICODE);
    }

}
