<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\Service;

use Joomla\CMS\Component\Router\RouterBase;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class Router extends RouterBase
{
    public function build(&$query)
    {
        $segments = [];

        if (isset($query['view'])) {
            $segments[] = $query['view'];
            unset($query['view']);
        }

        if (isset($query['itemComponent'])) {
            $segments[] = $query['itemComponent'];
            unset($query['itemComponent']);
        }

        if (isset($query['itemView'])) {
            $segments[] = $query['itemView'];
            unset($query['itemView']);
        }

        if (isset($query['itemId'])) {
            $segments[] = $query['itemId'];
            unset($query['itemId']);
        }

        return $segments;
    }


    public function parse(&$segments)
    {
        $vars = ['view' => $segments[0]];
        unset($segments[0]);

        if (isset($segments[1])) {
            $vars['itemComponent'] = $segments[1];
            unset($segments[1]);
        }

        if (isset($segments[2])) {
            $vars['itemView'] = $segments[2];
            unset($segments[2]);
        }

        if (isset($segments[3])) {
            $vars['itemId'] = $segments[3];
            unset($segments[3]);
        }

        return $vars;
    }
}
