<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\Model;

use Firecoders\Component\CommentBox\Administrator\Helper\UserHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\User\CurrentUserTrait;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class UsersModel extends ListModel
{
    use CurrentUserTrait;

    protected function populateState($ordering = 'comment.created_by', $direction = 'DESC')
    {
        $app   = Factory::getApplication();
        $input = $app->getInput();

        $value = $input->get('limit', $app->get('list_limit', 0), 'uint');
        if ($value > 1000) {
            $value = 1000;
        }
        $this->setState('list.limit', $value);

        $this->setState('list.start', 0);

        $value = $input->getCmd('itemComponent');
        $this->setState('filter.item_component', $value);

        $value = $input->getCmd('itemView');
        $this->setState('filter.item_view', $value);

        $value = $input->getInt('itemId');
        $this->setState('filter.item_id', $value);

        $params = $app->getParams();
        $this->setState('params', $params);
    }

    protected function getStoreId($id = '')
    {
        $id .= ':' . serialize($this->getState('filter.item_component'));
        $id .= ':' . serialize($this->getState('filter.item_view'));
        $id .= ':' . serialize($this->getState('filter.item_id'));
        $id .= ':' . serialize($this->getState('filter.page_id'));

        return parent::getStoreId($id);
    }


    protected function getListQuery()
    {
        $db = $this->getDatabase();

        $query = $db->getQuery(true);

        $query->select($db->qn('comment.created_by'));
        $query->from('#__commentbox_comments AS comment');
        $query->join('RIGHT', '#__users AS user ON user.id = comment.created_by');
        $query->select($db->qn('user.name'));
        $query->select($db->qn('user.id'));
        $query->select($db->qn('user.email'));
        $query->where('comment.state = ' . $db->q(1));
        $query->where('comment.created_by != ' . $db->q($this->getCurrentUser()->id));
        $query->where('comment.page_id = ' . $db->q($this->getState('filter.page_id')));
        $query->group($db->qn('comment.created_by'));

        return $query;
    }

    public function getItems()
    {
        $pageId = $this->getPageId();

        if (!$pageId) {
            return [];
        }

        $this->setState('filter.page_id', $pageId);

        $items = parent::getItems();

        foreach ($items as $item) {
            $item->avatar = UserHelper::getAvatar($item->email);
            unset($item->email);
            unset($item->created_by);
        }

        return $items;
    }

    private function getPageId()
    {
        $db = $this->getDatabase();

        $query = $db->getQuery(true);
        $query->select($db->qn('id'));
        $query->from($db->qn('#__commentbox_pages'));

        if (!$this->getState('filter.item_component')) {
            throw new \Exception(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        $query->where($db->qn('component'). ' = ' . $db->q($this->getState('filter.item_component')));

        if (!$this->getState('filter.item_view')) {
            throw new \Exception(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        $query->where($db->qn('view'). ' = ' . $db->q($this->getState('filter.item_view')));

        if (!$this->getState('filter.item_id')) {
            throw new \Exception(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        $query->where($db->qn('key'). ' = ' . $db->q($this->getState('filter.item_id')));

        $db->setQuery($query, 0, 1);
        $pageId = $db->loadResult();

        return $pageId;
    }

}
