<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\Controller;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Controller\Exception;
use Joomla\CMS\Session\Session;
use Tobscure\JsonApi\Exception\InvalidParameterException;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class VotesController extends BaseController
{
    public function getModel($name = 'Comment', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    protected function allowVote()
    {
        $user = $this->app->getIdentity();

        return !$user->guest;
    }

    public function vote()
    {
        $data  = $this->input->get('data', json_decode($this->input->json->getRaw(), true), 'array');

        $token = Session::getFormToken();

        if (!isset($data[$token]) || $data[$token] != 1) {
            throw new NotAllowed(Text::_('JINVALID_TOKEN_NOTICE'), 403);
        }

        if (!isset($data['id']) || !is_numeric($data['id'])) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if (!isset($data['vote']) || !is_numeric($data['vote'])) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if ($data['vote'] != 1 && $data['vote'] != -1) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if (!$this->allowVote()) {
            throw new NotAllowed(Text::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN'), 403);
        }

        $model   = $this->getModel('Comment');
        $comment = $model->getItem($data['id']);

        if (!$comment || $comment->state != 1) {
            throw new Exception\ResourceNotFound(Text::_('JLIB_APPLICATION_ERROR_RECORD'), 404);
        }

        $user  = $this->app->getIdentity();
        $model = $this->getModel('Vote');
        $table = $model->getTable();

        $voted = $table->load(['comment_id' => $data['id'], 'user_id' => $user->id]);

        if ($voted && $table->vote == $data['vote']) {

            $table->delete();

            $response = [
                'vote'    => $table->vote,
                'deleted' => true,
            ];

            echo json_encode($response, JSON_UNESCAPED_UNICODE);

            return $this;
        }

        $table->user_id    = $user->id;
        $table->vote       = $data['vote'];
        $table->comment_id = $data['id'];

        $result = $table->store();

        if (!$result) {
            throw new \RuntimeException(Text::_('JLIB_APPLICATION_ERROR_SAVE_FAILED'), 500);
        }

        $response = [
            'vote'    => $table->vote,
            'changed' => $voted ? true : false,
        ];

        echo json_encode($response, JSON_UNESCAPED_UNICODE);

        return $this;
    }
}
