<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\Controller;

use Firecoders\Component\CommentBox\Administrator\Helper\ReactionHelper;
use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Controller\Exception;
use Joomla\CMS\Session\Session;
use Tobscure\JsonApi\Exception\InvalidParameterException;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class ReactionsController extends BaseController
{
    public function getModel($name = 'Comment', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    protected function allowReact()
    {
        $user = $this->app->getIdentity();

        return !$user->guest;
    }

    public function react()
    {
        $data  = $this->input->get('data', json_decode($this->input->json->getRaw(), true), 'array');

        $token = Session::getFormToken();

        if (!isset($data[$token]) || $data[$token] != 1) {
            throw new NotAllowed(Text::_('JINVALID_TOKEN_NOTICE'), 403);
        }

        if (!isset($data['id']) || !is_numeric($data['id'])) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if (!isset($data['reaction'])) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if (!ReactionHelper::isValidReaction($data['reaction'])) {
            throw new InvalidParameterException(Text::_('COM_COMMENTBOX_ERROR_BAD_REQUEST'), 400);
        }

        if (!$this->allowReact()) {
            throw new NotAllowed(Text::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN'), 403);
        }

        $model   = $this->getModel('Comment');
        $comment = $model->getItem($data['id']);

        if (!$comment || $comment->state != 1) {
            throw new Exception\ResourceNotFound(Text::_('JLIB_APPLICATION_ERROR_RECORD'), 404);
        }

        $user  = $this->app->getIdentity();
        $model = $this->getModel('Reaction');
        $table = $model->getTable();

        $type  = $data['reaction'];
        $value = ReactionHelper::getReactionValue($type);

        $reacted = $table->load(['comment_id' => $data['id'], 'user_id' => $user->id]);

        if ($reacted) {

            if ($table->reaction == $value) {

                $table->delete();

                $response = [
                    'reaction' => $type,
                    'deleted'  => true,
                ];

                echo json_encode($response, JSON_UNESCAPED_UNICODE);

                return $this;
            }

            $previousType = ReactionHelper::getReactionType($table->reaction);
        }

        $table->user_id        = $user->id;
        $table->reaction       = $value;
        $table->comment_id     = $data['id'];
        $result                = $table->store();

        if (!$result) {
            throw new \RuntimeException(Text::_('JLIB_APPLICATION_ERROR_SAVE_FAILED'), 500);
        }

        $response = [
            'reaction' => $type,
            'value'    => $value,
            'changed'  => $reacted ? true : false,
            'previous' => $reacted ? $previousType : null,
        ];

        echo json_encode($response, JSON_UNESCAPED_UNICODE);

        return $this;
    }
}
