<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Site\Controller;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Factory;
use Joomla\CMS\Image\Image;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Uri\Uri;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class FilesController extends BaseController
{
    public function upload()
    {
        $this->checkToken();

        $user = Factory::getApplication()->getIdentity();
        if (!$user->authorise('core.upload', 'com_commentbox')) {
            throw new NotAllowed(Text::_('COM_COMMENTBOX_COULD_NOT_UPLOAD_IMAGE'), 403);
        }

        $application = Factory::getApplication();
        $file        = $application->input->files->get('file');

        if (!Folder::exists(JPATH_SITE . '/media/commentbox/tmp')) {
            Folder::create(JPATH_SITE . '/media/commentbox/tmp');
        }

        try {
            $imageProperties = Image::getImageFileProperties($file['tmp_name']);
        } catch (\Exception $e) {
            throw new NotAllowed(Text::_('COM_COMMENTBOX_COULD_NOT_UPLOAD_IMAGE'), 400);
        }

        $upload    = uniqid().'.'.$this->getImageExtensionFromMime($imageProperties->mime);
        $result    = File::upload($file['tmp_name'], JPATH_SITE . '/media/commentbox/tmp/'.$upload);

        if (!$result) {
            throw new \Exception(Text::_('COM_COMMENTBOX_COULD_NOT_UPLOAD_IMAGE'));
        }

        $image = new Image(JPATH_SITE . '/media/commentbox/tmp/'.$upload);
        $image->resize(1000, 1000, false, Image::SCALE_INSIDE);
        $image->toFile(JPATH_SITE . '/media/commentbox/tmp/'.$upload, $imageProperties->type, ['quality' => $imageProperties->type === IMAGETYPE_PNG ? 6 : 90]);
        $image->destroy();

        $response = ['src' => Uri::root(true) . '/media/commentbox/tmp/' . $upload,];
        echo json_encode($response);

        return $this;
    }

    protected function getImageExtensionFromMime($mime)
    {
        if ($mime === 'image/jpeg') {
            return 'jpeg';
        } elseif ($mime === 'image/gif') {
            return 'gif';
        } elseif ($mime === 'image/png' || $mime === 'image/apng') {
            return 'png';
        } elseif ($mime === 'image/webp') {
            return 'webp';
        } elseif ($mime === 'image/avif') {
            return 'avif';
        } elseif ($mime === 'image/svg+xml') {
            return 'svg';
        }
    }
}
