<?php
/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

\defined('_JEXEC') or die;

use Firecoders\Component\CommentBox\Administrator\Helper\CommentBoxHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

$wa = $this->document->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect');

$user      = $this->getCurrentUser();
$canChange = $user->authorise('core.manage', 'com_commentbox');
?>
<form action="<?php echo Route::_('index.php?option=com_commentbox&view=pages'); ?>" method="post" name="adminForm" id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
                <?php if (empty($this->items)) : ?>
                    <div class="alert alert-info">
                        <span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
                        <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                    </div>
                <?php else : ?>
                    <table class="table" id="commentList">
                        <caption class="visually-hidden">
                            <?php echo Text::_('COM_COMMENTBOX_PAGES'); ?>,
                            <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
                            <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                        </caption>
                        <thead>
                            <tr>
                                <td class="w-1 text-center">
                                    <?php echo HTMLHelper::_('grid.checkall'); ?>
                                </td>
                                <th scope="col" class="w-1 text-center">
                                        <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'page.state', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering')));?>
                                    </th>
                                <th scope="col">
                                    <?php echo Text::_('COM_COMMENTBOX_TITLE'); ?>
                                </th>
                                <th scope="col" class="w-10 text-center d-none d-md-table-cell">
                                    <span class="d-none d-lg-inline"><?php echo HTMLHelper::_('searchtools.sort', 'JPUBLISHED', 'page.comments_published', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?></span>
                                </th>
                                <th scope="col" class="w-10 text-center d-none d-md-table-cell">
                                    <span class="d-none d-lg-inline"><?php echo HTMLHelper::_('searchtools.sort', 'JUNPUBLISHED', 'page.comments_unpublished', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?></span>
                                </th>
                                <th scope="col" class="w-10 text-center d-none d-md-table-cell">
                                    <span class="d-none d-lg-inline"><?php echo HTMLHelper::_('searchtools.sort', 'COM_COMMENTBOX_SPAM', 'page.comments_spam', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?></span>
                                </th>
                                <th scope="col" class="w-10 text-center d-none d-md-table-cell">
                                    <span class="d-none d-lg-inline"><?php echo HTMLHelper::_('searchtools.sort', 'JTRASHED', 'page.comments_trashed', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?></span>
                                </th>
                                <th scope="col" class="text-center w-5">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'page.id', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($this->items as $i => $item) :?>
                                 <tr class="row<?php echo $i % 2; ?>">
                                     <td class="text-center">
                                        <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb'); ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo HTMLHelper::_('jgrid.state', HTMLHelper::_('pages.commentsStates'), $item->state, $i, 'pages.', $canChange);?>
                                    </td>
                                    <td>
                                        <a href="<?php echo $item->editLink; ?>"><?php echo $this->escape($item->title); ?></a>
                                        <div class="small"><a target="_blank" href="<?php echo $item->url; ?>"><?php echo $item->link; ?></a></div>
                                    </td>
                                    <td class="text-center btns d-none d-md-table-cell itemnumber">
                                        <a class="btn btn-success" href="<?php echo Route::_('index.php?option=com_commentbox&view=comments&filter[page_id]=' . (int) $item->id . '&filter[state]=1'); ?>" aria-describedby="tip-published-<?php echo $i; ?>">
                                            <?php echo $item->comments_published; ?>
                                        </a>
                                        <div role="tooltip" id="tip-published-<?php echo $i; ?>">
                                            <?php echo Text::_('COM_COMMENTBOX_PUBLISHED_COMMENTS'); ?>
                                        </div>
                                    </td>
                                    <td class="text-center btns d-none d-md-table-cell itemnumber">
                                        <a class="btn btn-warning" href="<?php echo Route::_('index.php?option=com_commentbox&view=comments&filter[page_id]=' . (int) $item->id . '&filter[state]=0'); ?>" aria-describedby="tip-unpublished-<?php echo $i; ?>">
                                            <?php echo $item->comments_unpublished; ?>
                                        </a>
                                        <div role="tooltip" id="tip-unpublished-<?php echo $i; ?>">
                                            <?php echo Text::_('COM_COMMENTBOX_UNPUBLISHED_COMMENTS'); ?>
                                        </div>
                                    </td>
                                    <td class="text-center btns d-none d-md-table-cell itemnumber">
                                        <a class="btn btn-danger" href="<?php echo Route::_('index.php?option=com_commentbox&view=comments&filter[page_id]=' . (int) $item->id . '&filter[state]=-1'); ?>" aria-describedby="tip-spam-<?php echo $i; ?>">
                                            <?php echo $item->comments_spam; ?>
                                        </a>
                                        <div role="tooltip" id="tip-spam-<?php echo $i; ?>">
                                            <?php echo Text::_('COM_COMMENTBOX_SPAM_COMMENTS'); ?>
                                        </div>
                                    </td>
                                    <td class="text-center btns d-none d-md-table-cell itemnumber">
                                        <a class="btn btn-dark" href="<?php echo Route::_('index.php?option=com_commentbox&view=comments&filter[page_id]=' . (int) $item->id . '&filter[state]=-2'); ?>" aria-describedby="tip-trashed-<?php echo $i; ?>">
                                            <?php echo $item->comments_trashed; ?>
                                        </a>
                                        <div role="tooltip" id="tip-trashed-<?php echo $i; ?>">
                                            <?php echo Text::_('COM_COMMENTBOX_TRASHED_COMMENTS'); ?>
                                        </div>
                                    </td>
                                    <td class="text-center w-5">
                                        <?php echo $item->id; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php // Load the pagination.?>
                    <?php echo $this->pagination->getListFooter(); ?>

                <?php endif; ?>

                <input type="hidden" name="task" value="">
                <input type="hidden" name="boxchecked" value="0">
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>
    <?php echo CommentBoxHelper::copyrights(); ?>
</form>
