<?php
/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

\defined('_JEXEC') or die;

use Firecoders\Component\CommentBox\Administrator\Helper\CommentBoxHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
    ->useScript('form.validate');

?>

<form action="<?php echo Route::_('index.php?option=com_commentbox&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="page-form" aria-label="<?php echo Text::_('COM_COMMENTBOX_PAGE_' . ((int) $this->item->id === 0 ? 'NEW' : 'EDIT'), true); ?>" class="form-validate">

    <?php echo $this->form->renderField('link'); ?>
    <?php echo $this->form->renderField('state'); ?>
    <?php echo $this->form->renderField('title'); ?>
    <?php echo $this->form->renderField('component'); ?>
    <?php echo $this->form->renderField('view'); ?>
    <?php echo $this->form->renderField('key'); ?>

    <input type="hidden" name="task" value="">
    <?php echo HTMLHelper::_('form.token'); ?>
</form>
<?php echo CommentBoxHelper::copyrights(); ?>
<script>

    const siteUrl = Joomla.getOptions('system.paths').rootFull;
    const data = {
        uri: ''
    };
    const linkField = document.getElementById('jform_link');
    const titleField = document.getElementById('jform_title');
    const componentField = document.getElementById('jform_component');
    const viewField = document.getElementById('jform_view');
    const keyField = document.getElementById('jform_key');

    linkField.addEventListener('input', async (event) => {

        data.uri = event.target.value;

        if(!data.uri) {
            return;
        }

        let xhr, result;

        try {

            xhr = await Joomla.request({
                url: 'index.php?option=com_commentbox&task=page.getUrlHash&format=json',
                method: 'POST',
                promise: true,
                headers: {
                    'Content-Type': 'application/json'
                },
                withCredentials: true,
                data: JSON.stringify(data)
            });

            result =  JSON.parse(xhr.response);
            data.hash = result.hash;

            xhr = await Joomla.request({
                url: siteUrl + 'index.php?option=com_commentbox&task=comments.parseUrl&format=json',
                method: 'POST',
                promise: true,
                headers: {
                    'Content-Type': 'application/json'
                },
                withCredentials: false,
                data: JSON.stringify(data)
            });

            result = JSON.parse(xhr.response);
            componentField.value = result.component;
            viewField.value = result.view;
            keyField.value = result.key;

        } catch (error) {
            componentField.value = '';
            viewField.value = '';
            keyField.value = '';
        }

        try {
            xhr = await Joomla.request({
                url: data.uri,
                method: 'GET',
                promise: true,
                withCredentials: false
            });

            const root = document.createElement('html');
            root.innerHTML = xhr.response;
            const title = root.querySelector('title').innerText;
            titleField.value = title;

        } catch (error) {
            titleField.value = '';
        }
    });
</script>