<?php
/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

\defined('_JEXEC') or die;

use Firecoders\Component\CommentBox\Administrator\Button\PublishedButton;
use Firecoders\Component\CommentBox\Administrator\Helper\CommentBoxHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

$wa = $this->document->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect')
    ->addInlineStyle('
    .js-modal-content-select-field { min-width: 250px }
    .js-modal-content-select-field button { font-size: 0 }
    .js-modal-content-select-field button span { font-size: initial }
    .commentbox-comment-text { max-height: 100px; overflow: hidden; }
    .commentbox-comment-text img { max-width: 100%; max-height: 300px; }
    .commentbox-comment.expanded .commentbox-comment-text { max-height: none; }
    .commentbox-comment .commentbox-collapse-button { display: none; }
    .commentbox-comment.expanded .commentbox-expand-button { display: none; }
    .commentbox-comment.expanded .commentbox-collapse-button { display: inline; }
    ')
    ->registerAndUseScript('commentbox.admin', 'commentbox/admin.js', [], ['defer' => true]);


$user      = $this->getCurrentUser();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$params    = ComponentHelper::getParams('com_commentbox');
?>
<form action="<?php echo Route::_('index.php?option=com_commentbox&view=comments'); ?>" method="post" name="adminForm" id="adminForm">
    <div class="row">
        <div class="col-md-12">
            <div id="j-main-container" class="j-main-container">
                <?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
                <?php if (empty($this->items)) : ?>
                    <div class="alert alert-info">
                        <span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
                        <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                    </div>
                <?php else : ?>
                    <table class="table" id="commentList">
                        <caption class="visually-hidden">
                            <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
                            <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                        </caption>
                        <thead>
                            <tr>
                                <td class="w-1 text-center">
                                    <?php echo HTMLHelper::_('grid.checkall'); ?>
                                </td>
                                <th scope="col" class="w-1 text-center">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'comment.state', $listDirn, $listOrder); ?>
                                </th>
                                <th scope="col">
                                    <?php echo Text::_('COM_COMMENTBOX_COMMENT'); ?>
                                </th>
                                <th scope="col" class="w-10">
                                    <?php echo Text::_('JAUTHOR'); ?>
                                </th>
                                <?php if ($params->get('ai_moderation', 0)) : ?>
                                <th scope="col">
                                    <?php echo Text::_('COM_COMMENTBOX_AI_MODERATION'); ?>
                                </th>
                                <?php endif; ?>
                                <th scope="col" class="text-center w-10">
                                    <?php echo Text::_('JDATE'); ?>
                                </th>
                                <?php if ($params->get('votes', 1)) : ?>
                                <th scope="col" class="text-center w-10">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'COM_COMMENTBOX_VOTES', 'comment.votes', $listDirn, $listOrder); ?>
                                </th>
                                <th scope="col" class="text-center w-10">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'COM_COMMENTBOX_SCORE', 'comment.score', $listDirn, $listOrder); ?>
                                </th>
                                <?php endif; ?>
                                <?php if ($params->get('reactions', 1)) : ?>
                                <th scope="col" class="text-center w-10">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'COM_COMMENTBOX_REACTIONS', 'comment.reactions', $listDirn, $listOrder); ?>
                                </th>
                                <?php endif; ?>
                                <th cope="col" class="text-center w-10">
                                    <?php echo Text::_('COM_COMMENTBOX_COMMENT_IP'); ?>
                                </th>
                                <th cope="col" class="text-center w-10">
                                    <?php echo Text::_('COM_COMMENTBOX_COMMENT_UA'); ?>
                                </th>
                                <th scope="col" class="w-5 d-none d-md-table-cell">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'comment.id', $listDirn, $listOrder); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($this->items as $i => $item) :
                                $ordering       = ($listOrder == 'ordering');
                                $canCreate      = $user->authorise('core.create', 'com_commentbox');
                                $canEdit        = $user->authorise('core.edit', 'com_commentbox');
                                $canChange      = $user->authorise('core.edit.state', 'com_commentbox');
                                ?>
                                 <tr class="row<?php echo $i % 2; ?>">
                                     <td class="text-center">
                                        <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb'); ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo (new PublishedButton())->render((int) $item->state, $i, ['task_prefix' => 'comments.', 'disabled' => !$canChange, 'id' => 'state-' . $item->id]); ?>
                                    </td>
                                    <th scope="row">
                                        <a  class="d-block" target="_blank" href="<?php echo $item->pageLink; ?>"><?php echo $this->escape($item->pageTitle); ?></a>
                                        <div class="commentbox-comment">
                                            <div class="commentbox-comment-text"><?php echo $item->text; ?></div>
                                            <a class="commentbox-expand-button hidden small" href="javascript:void()"><?php echo Text::_('COM_COMMENTBOX_EXPAND'); ?></a>
                                            <a class="commentbox-collapse-button hidden small" href="javascript:void()"><?php echo Text::_('COM_COMMENTBOX_COLLAPSE'); ?></a>
                                        </div>
                                    </th>
                                    <td>
                                        <div class="d-flex">
                                            <div class="pe-2 pb-1"><img width="48" class="rounded" src="<?php echo $item->userAvatar; ?>" alt="<?php echo $this->escape($item->userEmail); ?>" /></div>
                                            <div>
                                                <?php if ($item->created_by): ?>
                                                <a class="d-block" href="index.php?option=com_users&task=user.edit&id=<?php echo $item->created_by; ?>">
                                                    <?php echo $this->escape($item->userName); ?>
                                                </a>
                                                <?php else: ?>
                                                <span class="d-block"><?php echo $this->escape($item->userName); ?></span>
                                                <?php endif; ?>
                                                <small><?php echo $this->escape($item->userEmail); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <?php if ($params->get('ai_moderation', 0)) : ?>
                                    <td>
                                        <?php if ($item->flagged === 1) : ?>
                                            <?php foreach ($item->flags as $flag) : ?>
                                            <a href="<?php echo Route::_('index.php?option=com_commentbox&view=comments&filter[flag_id][]=' . $flag->id); ?>" class="badge bg-warning"  aria-describedby="tip-flag-<?php echo $flag->id; ?>"><?php echo Text::_($flag->key); ?></a>
                                            <span role="tooltip" id="tip-flag-<?php echo $flag->id; ?>">
                                                <?php echo Text::sprintf('COM_COMMENTBOX_FLAG_SCORE', Text::_($flag->key), $flag->score); ?>
                                            </span>
                                            <?php endforeach; ?>
                                        <?php elseif ($item->flagged === 0) : ?>
                                            <span class="badge bg-success"><?php echo Text::_('COM_COMMENTBOX_PASSED'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <td class="text-center">
                                        <?php echo HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC5')); ?>
                                    </td>
                                    <?php if ($params->get('votes', 1)) : ?>
                                    <td class="small d-none d-md-table-cell text-center">
                                        <?php echo $item->votes; ?>
                                    </td>
                                    <td class="small d-none d-md-table-cell text-center">
                                        <?php echo $item->score; ?>
                                    </td>
                                    <?php endif; ?>
                                    <?php if ($params->get('reactions', 1)) : ?>
                                    <td class="small d-none d-md-table-cell text-center">
                                        <?php echo $item->reactions; ?>
                                    </td>
                                    <?php endif; ?>
                                    <td class="small d-none d-md-table-cell text-center">
                                        <?php echo $item->ip; ?>
                                    </td>
                                    <td class="small d-none d-md-table-cell text-center">
                                        <?php echo $this->escape($item->user_agent); ?>
                                    </td>
                                    <td class="d-none d-md-table-cell">
                                        <?php echo $item->id; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php // Load the pagination.?>
                    <?php echo $this->pagination->getListFooter(); ?>

                <?php endif; ?>

                <input type="hidden" name="task" value="">
                <input type="hidden" name="boxchecked" value="0">
                <?php echo HTMLHelper::_('form.token'); ?>
            </div>
        </div>
    </div>

    <?php echo CommentBoxHelper::copyrights(); ?>
</form>
