<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\View\Pages;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class HtmlView extends BaseHtmlView
{
    public $filterForm;
    public $activeFilters = [];
    protected $items      = [];
    protected $pagination;
    protected $state;


    public function display($tpl = null): void
    {
        $model               = $this->getModel();
        $this->items         = $model->getItems();
        $this->pagination    = $model->getPagination();
        $this->state         = $model->getState();
        $this->filterForm    = $model->getFilterForm();
        $this->activeFilters = $model->getActiveFilters();

        if (\count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $this->addToolbar();

        parent::display($tpl);
    }


    protected function addToolbar(): void
    {
        $user    = $this->getCurrentUser();
        $toolbar = Toolbar::getInstance();

        ToolbarHelper::title(Text::_('COM_COMMENTBOX_MANAGER_PAGES'), 'folder');


        if ($user->authorise('core.admin', 'com_commentbox')) {

            $toolbar->addNew('page.add');

            $dropdown = $toolbar->dropdownButton('status-group', 'JTOOLBAR_CHANGE_STATUS')
                ->toggleSplit(false)
                ->icon('icon-ellipsis-h')
                ->buttonClass('btn btn-action')
                ->listCheck(true);

            $childBar = $dropdown->getChildToolbar();

            if ($this->state->get('filter.published') != '1') {
                $childBar->publish('pages.publish', 'COM_COMMENTBOX_ENABLE_COMMENTS')->listCheck(true);
            }

            if ($this->state->get('filter.published') != '0') {
                $childBar->unpublish('pages.unpublish', 'COM_COMMENTBOX_DISABLE_COMMENTS')->listCheck(true);
            }

            if ($this->state->get('filter.published') != '-1') {
                $childBar->standardButton('stop', 'COM_COMMENTBOX_CLOSE_COMMENTS', 'pages.close')->listCheck(true);
            }

            $childBar->delete('pages.deleteComments', 'COM_COMMENTBOX_DELETE_COMMENTS')->message('JGLOBAL_CONFIRM_DELETE')->listCheck(true);


            $childBar->delete('pages.delete', 'JTOOLBAR_DELETE')->message('JGLOBAL_CONFIRM_DELETE')->listCheck(true);
        }

        if ($user->authorise('core.admin', 'com_mails')) {
            $toolbar->link('COM_COMMENTBOX_MAIL_TEMPLATES', 'index.php?option=com_mails&filter[extension]=com_commentbox');
        }

        if ($user->authorise('core.admin', 'com_commentbox') || $user->authorise('core.options', 'com_commentbox')) {
            $toolbar->preferences('com_commentbox');
        }

    }
}
