<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\View\Page;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class HtmlView extends BaseHtmlView
{
    protected $form;
    protected $item;
    protected $state;

    public function display($tpl = null): void
    {
        $model       = $this->getModel();
        $this->form  = $model->getForm();
        $this->item  = $model->getItem();
        $this->state = $model->getState();

        // Check for errors.
        if (\count($errors = $this->get('Errors'))) {
            throw new GenericDataException(implode("\n", $errors), 500);
        }

        $this->addToolbar();

        parent::display($tpl);
    }

    protected function addToolbar(): void
    {
        Factory::getApplication()->getInput()->set('hidemainmenu', true);

        $user       = $this->getCurrentUser();
        $isNew      = ($this->item->id == 0);
        $toolbar    = Toolbar::getInstance();

        ToolbarHelper::title($isNew ? Text::_('COM_COMMENTBOX_MANAGER_PAGE_NEW') : Text::_('COM_COMMENTBOX_MANAGER_PAGE_EDIT'), 'folder');

        if ($user->authorise('core.manage', 'com_commentbox')) {
            $toolbar->apply('page.apply');
            $toolbar->save('page.save');
            if (empty($this->item->id)) {
                $toolbar->cancel('page.cancel', 'JTOOLBAR_CANCEL');
            } else {
                $toolbar->cancel('page.cancel');
            }
        }

    }
}
