<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Table;

use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class VoteTable extends Table
{
    public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null)
    {
        parent::__construct('#__commentbox_votes', 'id', $db, $dispatcher);
    }

    public function store($updateNulls = false)
    {
        try {
            $this->_db->transactionStart();

            $query = $this->_db->getQuery(true);
            $query->update($this->_db->qn('#__commentbox_comments'));

            if ($this->vote == 1) {
                $query->set($this->_db->qn('upvotes') . ' = ' . $this->_db->qn('upvotes') . ' + 1');
                if ($this->hasPrimaryKey()) {
                    $query->set($this->_db->qn('downvotes') . ' = ' . $this->_db->qn('downvotes') . ' - 1');
                    $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' + 2');
                } else {
                    $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' + 1');
                }
            } elseif ($this->vote == -1) {
                $query->set($this->_db->qn('downvotes') . ' = ' . $this->_db->qn('downvotes') . ' + 1');
                if ($this->hasPrimaryKey()) {
                    $query->set($this->_db->qn('upvotes') . ' = ' . $this->_db->qn('upvotes') . ' - 1');
                    $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' - 2');
                } else {
                    $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' - 1');
                }
            }

            if (!$this->hasPrimaryKey()) {
                $query->set($this->_db->qn('votes') . ' = ' . $this->_db->qn('votes') . ' + 1');
            }

            $query->where($this->_db->qn('id') . ' = ' . $this->_db->q($this->comment_id));

            $this->_db->setQuery($query);
            $this->_db->execute();

            parent::store($updateNulls);

            $this->_db->transactionCommit();
        } catch (Exception $e) {
            $this->_db->transactionRollback();

            return false;
        }

        return true;
    }

    public function delete($pk = null)
    {
        try {
            $this->_db->transactionStart();

            $query = $this->_db->getQuery(true);
            $query->update($this->_db->qn('#__commentbox_comments'));

            if ($this->vote == 1) {
                $query->set($this->_db->qn('upvotes') . ' = ' . $this->_db->qn('upvotes') . ' - 1');
                $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' - 1');
            } elseif ($this->vote == -1) {
                $query->set($this->_db->qn('downvotes') . ' = ' . $this->_db->qn('downvotes') . ' - 1');
                $query->set($this->_db->qn('score') . ' = ' . $this->_db->qn('score') . ' + 1');
            }

            $query->set($this->_db->qn('votes') . ' = ' . $this->_db->qn('votes') . ' - 1');

            $query->where($this->_db->qn('id') . ' = ' . $this->_db->q($this->comment_id));

            $this->_db->setQuery($query);
            $this->_db->execute();

            parent::delete($pk);

            $this->_db->transactionCommit();
        } catch (Exception $e) {
            $this->_db->transactionRollback();

            return false;
        }

        return true;
    }

}
