<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Table;

use Firecoders\Component\CommentBox\Administrator\Helper\ReactionHelper;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class ReactionTable extends Table
{
    public $previousReaction = null;

    public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null)
    {
        parent::__construct('#__commentbox_reactions', 'id', $db, $dispatcher);
    }

    public function store($updateNulls = false)
    {
        try {
            $this->_db->transactionStart();

            $column = ReactionHelper::getReactionType($this->reaction);

            $query = $this->_db->getQuery(true);
            $query->update($this->_db->qn('#__commentbox_reactions_counters'));
            $query->set($this->_db->qn($column) . ' = ' . $this->_db->qn($column) . ' + 1');
            if ($this->hasPrimaryKey() && $this->previousReaction) {
                $column = ReactionHelper::getReactionType($this->previousReaction);
                $query->set($this->_db->qn($column) . ' = ' . $this->_db->qn($column) . ' - 1');
            }
            $query->where($this->_db->qn('comment_id') . ' = ' . $this->_db->q($this->comment_id));
            $this->_db->setQuery($query);
            $this->_db->execute();

            if (!$this->hasPrimaryKey()) {
                $query = $this->_db->getQuery(true);
                $query->update($this->_db->qn('#__commentbox_comments'));
                $query->set($this->_db->qn('reactions') . ' = ' . $this->_db->qn('reactions') . ' + 1');
                $query->where($this->_db->qn('id') . ' = ' . $this->_db->q($this->comment_id));
                $this->_db->setQuery($query);
                $this->_db->execute();
            }

            parent::store($updateNulls);

            $this->_db->transactionCommit();
        } catch (Exception $e) {
            $this->_db->transactionRollback();

            return false;
        }

        return true;
    }

    public function delete($pk = null)
    {
        try {
            $this->_db->transactionStart();

            $query = $this->_db->getQuery(true);
            $query->update($this->_db->qn('#__commentbox_reactions_counters'));
            $column = ReactionHelper::getReactionType($this->reaction);
            $query->set($this->_db->qn($column) . ' = ' . $this->_db->qn($column) . ' - 1');
            $query->where($this->_db->qn('comment_id') . ' = ' . $this->_db->q($this->comment_id));
            $this->_db->setQuery($query);
            $this->_db->execute();

            $query = $this->_db->getQuery(true);
            $query->update($this->_db->qn('#__commentbox_comments'));
            $query->set($this->_db->qn('reactions') . ' = ' . $this->_db->qn('reactions') . ' - 1');
            $query->where($this->_db->qn('id') . ' = ' . $this->_db->q($this->comment_id));
            $this->_db->setQuery($query);
            $this->_db->execute();

            parent::delete($pk);

            $this->_db->transactionCommit();
        } catch (Exception $e) {
            $this->_db->transactionRollback();

            return false;
        }

        return true;
    }

}
