<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Table;

use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Event\DispatcherInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PageTable extends Table
{
    public function __construct(DatabaseDriver $db, DispatcherInterface $dispatcher = null)
    {
        parent::__construct('#__commentbox_pages', 'id', $db, $dispatcher);
        $this->setColumnAlias('published', 'state');
    }

    public function delete($pk = null)
    {
        try {
            $this->_db->transactionStart();

            parent::delete($pk);

            $query = $this->_db->getQuery(true);
            $query->delete($this->_db->qn('#__commentbox_comments'));
            if (\is_array($pk)) {
                $query->where($this->_db->qn('page_id').' IN ('.implode(',', $pk).')');
            } else {
                $query->where($this->_db->qn('page_id').' = '.$this->_db->q($pk));
            }
            $this->_db->setQuery($query);
            $this->_db->execute();

            $this->_db->transactionCommit();

        } catch (Exception $e) {

            $this->_db->transactionRollback();
            return false;
        }

        return true;
    }
}
