<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Rule;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormRule;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class ParentIdRule extends FormRule
{
    public function test(\SimpleXMLElement $element, $value, $group = null, Registry $input = null, Form $form = null)
    {
        if ($value) {

            $model  = Factory::getApplication()->bootComponent('com_commentbox')->getMVCFactory()->createModel('Comment', 'Administrator', ['ignore_request' => true]);
            $parent = $model->getItem($value);

            // Parent state validation
            if (!$parent || !$parent->state || $parent->page_id != $input->get('page_id')) {
                return false;
            }

            // Level validation
            $level = 1;
            while ($parent->parent_id > 0) {
                $level++;
                $parent = $model->getItem($parent->parent_id);
            }

            if ($level > 2) {
                return false;
            }
        }

        return true;
    }
}
