<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Rule;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormRule;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class ItemComponentRule extends FormRule
{
    public function test(\SimpleXMLElement $element, $value, $group = null, Registry $input = null, Form $form = null)
    {
        $params    = ComponentHelper::getParams('com_commentbox');
        $component = 'com_'.$value;
        $key       = $component.'_'.$input->get('view');
        $default   = $key === 'com_content_article' ? 1 : 0;

        if (!$params->get($key, $default)) {
            return false;
        }

        $db    = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->qn('extension_id'))->from($db->qn('#__extensions'))
        ->where($db->qn('type'). ' = '.$db->q('component'))
        ->where($db->qn('element'). ' = '.$db->q($component))
        ->where($db->qn('enabled'). ' = '.$db->q('1'))
        ->where($db->qn('client_id'). ' = '.$db->q('1'));
        $db->setQuery($query);
        $result = $db->loadResult();

        if (!$result) {
            return false;
        }

        return true;
    }
}
