<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Rule;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\Rule\EmailRule;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class CommentEmailRule extends EmailRule
{
    public function test(\SimpleXMLElement $element, $value, $group = null, Registry $input = null, Form $form = null)
    {

        $isValidEmail = parent::test($element, $value, $group, $input, $form);

        if (!$isValidEmail) {
            return false;
        }

        $user = Factory::getApplication()->getIdentity();

        if ($user->guest) {
            $db    = $this->getDatabase();
            $query = $db->getQuery(true);
            $query->select($db->qn('id'))
            ->from($db->qn('#__users'))
            ->where($db->qn('email') . ' = :email')
            ->bind(':email', $value);
            $db->setQuery($query);
            $duplicate = (int) $db->loadResult();
            if ($duplicate) {
                throw new \UnexpectedValueException(Text::_('JLIB_DATABASE_ERROR_EMAIL_INUSE'));
            }
        }

        return true;
    }
}
