<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Model;

use Joomla\CMS\MVC\Model\AdminModel;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class VoteModel extends AdminModel
{
    public function getForm($data = [], $loadData = true)
    {
        return parent::getForm($data, $loadData);
    }

    public function getUserVotes(&$comments, $userId)
    {
        $commentIds = [];

        foreach ($comments as &$comment) {
            $commentIds[] = $comment->id;
        }

        if (!$userId || empty($commentIds)) {
            return;
        }

        $db    = $this->getDbo();
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from('#__commentbox_votes');
        $query->where('user_id = ' . $db->q($userId));
        $query->where('comment_id IN (' . implode(',', $commentIds) . ')');
        $db->setQuery($query);
        $votes = $db->loadAssocList('comment_id', 'vote');

        if (empty($votes)) {
            return;
        }

        foreach ($comments as &$comment) {
            if (isset($votes[$comment->id])) {
                if ($votes[$comment->id] == 1) {
                    $comment->upvoted = true;
                } elseif ($votes[$comment->id] == -1) {
                    $comment->downvoted = true;
                }
            }
        }
    }
}
