<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Model;

use Joomla\CMS\MVC\Model\AdminModel;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class ReactionModel extends AdminModel
{
    public function getForm($data = [], $loadData = true)
    {
        return parent::getForm($data, $loadData);
    }

    public function getUserReactions(&$comments, $userId)
    {
        $commentIds = [];

        foreach ($comments as &$comment) {
            $commentIds[] = $comment->id;
        }

        if (!$userId || empty($commentIds)) {
            return;
        }

        $db    = $this->getDbo();
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from('#__commentbox_reactions');
        $query->where('user_id = ' . $db->q($userId));
        $query->where('comment_id IN (' . implode(',', $commentIds) . ')');
        $db->setQuery($query);
        $reactions = $db->loadAssocList('comment_id', 'reaction');

        if (empty($reactions)) {
            return;
        }

        foreach ($comments as &$comment) {
            if (isset($reactions[$comment->id])) {
                $comment->reacted = $reactions[$comment->id];
            }
        }
    }
}
