<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Model;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PagesModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id', 'page.id',
                'state', 'page.state',
                'comments_total', 'page.comments_total',
                'comments_published', 'page.comments_published',
                'comments_unpublished', 'page.comments_unpublished',
                'comments_spam', 'page.comments_spam',
                'comments_trashed', 'page.comments_trashed',
                'component', 'page.component',
                'view', 'page.view',
                'key', 'page.key',
            ];
        }

        parent::__construct($config);
    }

    protected function getStoreId($id = '')
    {
        $id .= ':' . $this->getState('filter.state');
        $id .= ':' . serialize($this->getState('filter.id'));
        $id .= ':' . $this->getState('filter.search');

        return parent::getStoreId($id);
    }

    protected function populateState($ordering = 'page.id', $direction = 'DESC')
    {
        $this->setState('params', ComponentHelper::getParams('com_commentbox'));

        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'int');
        $this->setState('filter.state', $state);

        $id = $this->getUserStateFromRequest($this->context . '.filter.id', 'filter_id');
        $this->setState('filter.id', $id);

        parent::populateState($ordering, $direction);
    }

    protected function getListQuery()
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);

        $query->select($this->getState('list.select', 'page.*'));
        $query->from('#__commentbox_pages AS page');

        if (is_numeric($this->getState('filter.state'))) {
            $query->where($db->qn('page.state').' = '.$db->q($this->getState('filter.state')));
        }

        if (\is_array($this->getState('filter.id'))) {
            $query->where('page.id IN (' . implode(',', $this->getState('filter.id')) . ')');
        } elseif (is_numeric($this->getState('filter.id'))) {
            $query->where('page.id = ' . $db->q($this->getState('filter.id')));
        }

        $search = $this->getState('filter.search');

        if (!empty($search)) {
            $search = $db->q('%' . str_replace(' ', '%', trim($search)) . '%');
            $query->where('(' . $db->qn('page.title') . ' LIKE '.$search.' OR ' . $db->qn('page.link') . ' LIKE ' . $search . ')');
        }

        $query->order($this->getState('list.ordering', 'page.id') . ' ' . $this->getState('list.direction', 'DESC'));

        return $query;
    }

    public function getItems()
    {
        $items = parent::getItems();

        foreach ($items as $item) {
            $item->url      = Uri::root().$item->link;
            $item->editLink = Route::_('index.php?option=com_commentbox&task=page.edit&id=' . $item->id);
        }

        return $items;
    }


    public function getTable($type = 'Page', $prefix = 'Administrator', $config = [])
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function resetCommentCounters($pageIds)
    {
        $db = $this->getDatabase();

        $query = $db->getQuery(true);
        $query->update($db->qn('#__commentbox_pages'));
        $query->set($db->qn('comments_total').' = 0');
        $query->set($db->qn('comments_published').' = 0');
        $query->set($db->qn('comments_unpublished').' = 0');
        $query->set($db->qn('comments_spam').' = 0');
        $query->set($db->qn('comments_trashed').' = 0');
        $query->where($db->qn('id').' IN ('.implode(',', $pageIds).')');

        $db->setQuery($query);
        $result = $db->execute();

        return $result;
    }
}
