<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PageModel extends AdminModel
{
    protected $text_prefix = 'COM_COMMENTBOX_PAGE';

    public function getForm($data = [], $loadData = true)
    {
        $form = $this->loadForm('com_commentbox.page', JPATH_ADMINISTRATOR.'/components/com_commentbox/forms/page.xml', ['control' => 'jform', 'load_data' => $loadData]);

        if (empty($form)) {
            return false;
        }

        return $form;
    }

    public function save($data)
    {
        $data['link'] = substr($data['link'], \strlen(Uri::root()));
        return parent::save($data);
    }


    public function getItemByResource($component, $view, $key)
    {
        $db    = $this->getDatabase();
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from('#__commentbox_pages');
        $query->where($db->qn('component').' = '.$db->q($component));
        $query->where($db->qn('view').' = '.$db->q($view));
        $query->where($db->qn('key').' = '.$db->q($key));

        $db->setQuery($query);
        $item = $db->loadObject();

        return $item;
    }


    protected function loadFormData()
    {
        $app  = Factory::getApplication();
        $data = $app->getUserState('com_commentbox.edit.page.data', []);


        if (empty($data)) {
            $data         = $this->getItem();
            if ($data->link) {
                $data->link   = Uri::root().$data->link;
            }
        }

        $this->preprocessData('com_commentbox.page', $data);

        return $data;
    }

}
