<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class UrlHelper
{
    public static function parse($url)
    {
        $uri  = Uri::getInstance($url);
        $path = $uri->getPath();

        if ($path !== '/') {
            $path = trim($path, '/');
        }

        $segments  = explode('/', $path);

        // Remove index.php
        if (\count($segments) && $segments[0] === 'index.php') {
            array_shift($segments);
        }

        // Handle routes without Itemid
        if (\count($segments) && $segments[0] === 'component') {

            $component = isset($segments[1]) ? $segments[1] : 'unknown';
            $view      = isset($segments[2]) ? $segments[2] : 'unknown';
            $key       = isset($segments[3]) ? $segments[3] : 'unknown';
            $Itemid    = 0;

            if (strpos($key, '-')) {
                $parts = explode('-', $key);
                $key   = end($parts);
            }

            return [$component, $view, $key, $Itemid];
        }

        // Use Joomla router for rest routes
        $uri         = Uri::getInstance(implode('/', $segments));
        $router      = Factory::getContainer()->get(SiteRouter::class);
        $application = Factory::getApplication();

        // Fix for router redirect when force SSL is used
        if ($application->get('force_ssl') == 2) {
            $router->detachRule('parse', [$router, 'parseCheckSSL'], SiteRouter::PROCESS_BEFORE);
        }

        try {
            $router->parse($uri);
            $query = $uri->getQuery(true);
        } catch (\Throwable $th) {
            return ['unknown', 'unknown', 0, 0];
        }

        $Itemid = isset($query['Itemid']) ? (int) $query['Itemid'] : 0;

        if ($Itemid) {
            $menu     = Factory::getApplication()->getMenu();
            $menuItem = $menu->getItem($Itemid);
            if ($menuItem) {
                $query = array_merge($menuItem->query, $query);
            }
        }

        $component = substr($query['option'], 4);
        $view      = $query['view'];

        $keyName = CommentBoxHelper::getKeyName($query['option']);

        if (isset($query[$keyName])) {
            $key = $query[$keyName];
            if (strpos($key, ':')) {
                [$key, $alias] = explode(':', $key);
            }
        } else {
            $key = 0;
        }

        // Joomla Router sets an active menu each time parse is used. We need to restore the current one if we are in frontend
        if ($application->isClient('site')) {
            $application->getMenu()->setActive($application->input->getInt('Itemid'));
        }

        return [$component, $view, $key, $Itemid];
    }
}
