<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class ReactionHelper
{
    protected static $reactions = [
        'like'    => 1,
        'love'    => 2,
        'funny'   => 3,
        'wow'     => 4,
        'sad'     => 5,
        'dislike' => 6,
        'angry'   => 7,
        /*'fire'      => 8,
        'celebrate' => 9,
        'thinking'  => 10,
        'support'   => 11,
        'cool'      => 12,
        'respect'   => 13,
        'cringe'    => 14,
        'clown'     => 15,
        'cantlook'  => 16,
        'boring'    => 17,*/
    ];

    protected static $enabled = null;

    public static function getReactions()
    {
        return static::$reactions;
    }

    public static function getEnabledReactions()
    {
        if (!\is_null(static::$enabled)) {
            return static::$enabled;
        }

        static::$enabled = [];

        $params = ComponentHelper::getParams('com_commentbox');

        if ($params->get('reactions', '1')) {

            $enabled         = $params->get('enabled_reactions', []);
            $reactions       = static::getReactions();
            static::$enabled = array_intersect_key($reactions, array_flip($enabled));
        }

        return static::$enabled;
    }

    public static function getReactionValue($type)
    {
        $reactions = static::getReactions();
        return isset($reactions[$type]) ? $reactions[$type] : 0;
    }

    public static function getReactionType($value)
    {
        $reactions = static::getReactions();
        return array_flip($reactions)[$value];
    }

    public static function isValidReaction($type)
    {
        return \array_key_exists($type, static::getEnabledReactions());
    }
}
