<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class HashHelper
{
    public static function generateHash($payload)
    {
        $params = ComponentHelper::getParams('com_commentbox');

        return hash('sha256', json_encode($payload).$params->get('secret'));
    }

    public static function checkHash($hash, $payload)
    {
        $params = ComponentHelper::getParams('com_commentbox');

        if (!$params->get('secret')) {
            return false;
        }

        if (!$hash) {
            return false;
        }

        return static::generateHash($payload) === $hash;
    }
}
