<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class GifHelper
{
    public static function fetch($search, $language = 'en', $limit = 60, $pos = null)
    {
        $params = ComponentHelper::getParams('com_commentbox');
        $apiKey = $params->get('tenor_api_key');

        if (empty($apiKey)) {
            throw new \RuntimeException(Text::_('COM_COMMENTBOX_ERROR_TENOR_API_KEY_MISSING'), 500);
        }

        $payload = [
            'key'           => $apiKey,
            'limit'         => $limit,
            'locale'        => $language,
            'media_filter'  => 'minimal',
            'contentfilter' => 'high',
            'ar_range'      => 'all',
        ];

        if ($search) {
            $payload['q'] = $search;
            $endpoint     = 'search';
        } else {
            $endpoint = 'featured';
        }

        if ($pos) {
            $payload['pos'] = $pos;
        }

        $url = 'https://tenor.googleapis.com/v2/' . $endpoint . '?' . http_build_query($payload);

        try {
            $http = HttpFactory::getHttp();

            $response = $http->get($url);

            if ($response->code !== 200) {
                throw new \RuntimeException(Text::_('COM_COMMENTBOX_ERROR_TENOR_API_REQUEST_FAILED'), 500);
            }

            $body    = json_decode($response->body);

            $results = [];

            foreach ($body->results as $result) {
                $results[] = [
                    'id'  => $result->id,
                    'url' => $result->media_formats->tinygif->url,
                ];
            }

            return (object) ['gifs' => $results, 'next' => $body->next];

        } catch (\Exception $e) {
            throw new \RuntimeException(Text::_('COM_COMMENTBOX_ERROR_FETCHING_GIFS'), 500);
        }
    }

}
