<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class CommentHelper
{
    public static function prepare(&$comment)
    {
        $user = Factory::getApplication()->getIdentity();

        $comment->level   = 1;
        $comment->replies = [];

        if (!$user->guest) {
            $comment->mine = $user->id == $comment->created_by;
        }

        $comment->relativeDate = HTMLHelper::_('date.relative', $comment->created);
        $comment->avatar       = UserHelper::getAvatar($comment->email);

        $comment->text = str_replace('src="/media/commentbox/uploads', 'src="'.Uri::root(true).'/media/commentbox/uploads', $comment->text);

        if ($comment->created_by && !$comment->email) {
            $comment->removed = true;
            $comment->name    = Text::_('COM_COMMENTBOX_DELETED_USER');
            $comment->text    = Text::_('COM_COMMENTBOX_DELETED_COMMENT');
        }

        if (isset($comment->flags)) {
            $comment->flags = array_map(function ($flag) {
                return Text::_($flag->key);
            }, $comment->flags);
        }

        $comment->reactions = [];
        $enabledReactions   = ReactionHelper::getEnabledReactions();

        foreach ($enabledReactions as $reaction => $value) {
            if (isset($comment->{'reactions_' . $reaction})) {
                $comment->reactions[$reaction] = (int) $comment->{'reactions_' . $reaction};
            }
        }

        arsort($comment->reactions, SORT_NUMERIC);

        unset($comment->created_by);
        unset($comment->email);
        unset($comment->typeAlias);
        unset($comment->email);
        unset($comment->ip);
        unset($comment->user_agent);
        unset($comment->created_by);
        unset($comment->modified_by);
        unset($comment->reactions_like);
        unset($comment->reactions_dislike);
        unset($comment->reactions_love);
        unset($comment->reactions_funny);
        unset($comment->reactions_wow);
        unset($comment->reactions_sad);
        unset($comment->reactions_angry);
    }

}
