<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class CaptchaHelper
{
    public static function isEnabled(): bool
    {
        $user = Factory::getApplication()->getIdentity();

        if (!$user->authorise('core.create', 'com_commentbox')) {
            return false;
        }

        $params = ComponentHelper::getParams('com_commentbox');

        return $params->get('captcha', '1') === '2' || ($params->get('captcha', '1') === '1' && $user->guest);
    }

    public static function challenge()
    {
        PluginHelper::importPlugin('commentbox', self::service());
        $challenge = Factory::getApplication()->triggerEvent('onCommentBoxCaptchaChallenge');

        return $challenge;
    }

    public static function verify($data): bool
    {
        if (!isset($data['captcha']) || !$data['captcha']) {
            return false;
        }

        PluginHelper::importPlugin('commentbox', self::service());

        try {
            $verified = Factory::getApplication()->triggerEvent('onCommentBoxCaptchaVerify', [$data['captcha']]);
        } catch (\Exception $exception) {
            Log::add(Text::_($exception->getMessage()), Log::WARNING, 'com_commentbox');
            $verified = false;
        }

        return $verified;
    }


    public static function load(): void
    {
        PluginHelper::importPlugin('commentbox', self::service());
        Factory::getApplication()->triggerEvent('onCommentBoxCaptchaLoad');
    }

    private static function service(): string
    {
        $params = ComponentHelper::getParams('com_commentbox');
        return $params->get('captcha_service', 'altcha');
    }

}
