<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Helper;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class AntiSpamHelper
{
    public static function isEnabled()
    {
        $user = Factory::getApplication()->getIdentity();

        $params = ComponentHelper::getParams('com_commentbox');

        return $params->get('anti_spam') === '2' || ($params->get('anti_spam') === '1' && $user->guest);
    }

    public static function checkSpam($comment): bool
    {
        $params  = ComponentHelper::getParams('com_commentbox');
        $service = $params->get('anti_spam_service');

        if (!$service) {
            return false;
        }

        if (\is_array($comment)) {
            $comment = (object) $comment;
        }

        PluginHelper::importPlugin('commentbox', $service);

        try {
            $result = Factory::getApplication()->triggerEvent('onCommentBoxSpamCheck', [$comment]);
        } catch (\Exception $exception) {
            Log::add(Text::_($exception->getMessage()), Log::WARNING, 'com_commentbox');
            $result = false;
        }

        return $result;
    }
}
