<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Field\Modal;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ModalSelectField;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\ParameterType;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PageField extends ModalSelectField
{
    protected $type = 'Modal_Page';

    public function setup(\SimpleXMLElement $element, $value, $group = null)
    {
        $result = parent::setup($element, $value, $group);

        if (!$result) {
            return $result;
        }

        Factory::getApplication()->getLanguage()->load('com_commentbox', JPATH_ADMINISTRATOR);

        $pagesUrl = (new Uri())->setPath(Uri::base(true) . '/index.php');
        $pagesUrl->setQuery([
            'option'                => 'com_commentbox',
            'view'                  => 'pages',
            'layout'                => 'modal',
            'tmpl'                  => 'component',
            Session::getFormToken() => 1,
        ]);

        $this->urls['select']        = (string) $pagesUrl;
        $this->urls['edit']          = (string) $pagesUrl;
        $this->buttonIcons['select'] = 'icon-folder';
        $this->buttonIcons['edit']   = 'icon-folder';
        $this->modalTitles['select'] = 'COM_COMMENTBOX_SELECT_A_PAGE';
        $this->hint                  = $this->hint ?: 'COM_COMMENTBOX_SELECT_A_PAGE';


        return $result;
    }

    protected function getValueTitle()
    {
        $value = (int) $this->value ?: '';
        $title = '';

        if ($value) {
            try {
                $db    = $this->getDatabase();
                $query = $db->getQuery(true)
                    ->select($db->qn('title'))
                    ->from($db->qn('#__commentbox_pages'))
                    ->where($db->qn('id') . ' = :value')
                    ->bind(':value', $value, ParameterType::INTEGER);
                $db->setQuery($query);

                $title = $db->loadResult();
            } catch (\Throwable $e) {
                Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
            }
        }

        return $title ?: $value;
    }

    protected function getRenderer($layoutId = 'default')
    {
        $layout = parent::getRenderer($layoutId);
        $layout->setComponent('com_commentbox');
        $layout->setClient(1);

        return $layout;
    }
}
