<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Controller;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Router\Route;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PagesController extends AdminController
{
    protected $text_prefix = 'COM_COMMENTBOX_PAGES';

    public function __construct($config = [], MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null)
    {
        parent::__construct($config, $factory, $app, $input);

        $this->registerTask('close', 'publish');
    }

    public function getModel($name = 'Page', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function publish()
    {
        // Check for request forgeries
        $this->checkToken();

        // Get items to publish from the request.
        $cid   = (array) $this->input->get('cid', [], 'int');
        $data  = ['publish' => 1, 'unpublish' => 0, 'close' => -1];
        $task  = $this->getTask();
        $value = ArrayHelper::getValue($data, $task, 0, 'int');

        // Remove zero values resulting from input filter
        $cid = array_filter($cid);

        if (empty($cid)) {
            $this->getLogger()->warning(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), ['category' => 'jerror']);
        } else {
            // Get the model.
            $model = $this->getModel();

            // Publish the items.
            try {
                $model->publish($cid, $value);
                $errors = $model->getErrors();
                $ntext  = $this->text_prefix . '_N_ITEMS_UPDATED';

                if ($errors) {
                    $this->app->enqueueMessage(
                        Text::plural($this->text_prefix . '_N_ITEMS_FAILED_UPDATING', \count($cid)),
                        CMSWebApplicationInterface::MSG_ERROR
                    );
                }

                if (\count($cid)) {
                    $this->setMessage(Text::plural($ntext, \count($cid)));
                }
            } catch (\Exception $e) {
                $this->setMessage($e->getMessage(), 'error');
            }
        }

        $this->setRedirect(
            Route::_(
                'index.php?option=' . $this->option . '&view=' . $this->view_list
                . $this->getRedirectToListAppend(),
                false
            )
        );
    }

    public function deleteComments()
    {
        $this->checkToken();

        $cid = (array) $this->input->get('cid', [], 'int');
        $cid = array_filter($cid);

        if (empty($cid)) {
            $this->getLogger()->warning(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), ['category' => 'jerror']);
        } else {
            $commentsModel = $this->getModel('Comments');
            $deleted       = $commentsModel->deletePageComments($cid);

            if ($deleted) {
                Factory::getApplication()->triggerEvent('onCommentBoxPageDeleteComments', ['com_commentbox.page', $cid]);
            }
        }

        $this->setRedirect(
            Route::_(
                'index.php?option=' . $this->option . '&view=' . $this->view_list
                . $this->getRedirectToListAppend(),
                false
            )
        );
    }
}
