<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Component\CommentBox\Administrator\Controller;

use Firecoders\Component\CommentBox\Administrator\Helper\HashHelper;
use Joomla\CMS\MVC\Controller\FormController;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


class PageController extends FormController
{
    protected $text_prefix = 'COM_COMMENTBOX_PAGE';

    public function save($key = null, $urlVar = null)
    {
        return parent::save($key, $urlVar);
    }

    public function getUrlHash()
    {
        $data = $this->input->get('data', json_decode($this->input->json->getRaw(), true), 'array');
        $hash = HashHelper::generateHash(['uri' => $data['uri']]);

        echo json_encode(['hash' => $hash], JSON_UNESCAPED_UNICODE);

        return $this;
    }
}
