CREATE TABLE IF NOT EXISTS `#__commentbox_votes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `vote` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_user` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_reactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `reaction` tinyint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_user` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_reactions_counters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `like` int unsigned NOT NULL DEFAULT '0',
  `dislike` int unsigned NOT NULL DEFAULT '0',
  `love` int unsigned NOT NULL DEFAULT '0',
  `funny` int unsigned NOT NULL DEFAULT '0',
  `wow` int unsigned NOT NULL DEFAULT '0',
  `sad` int unsigned NOT NULL DEFAULT '0',
  `angry` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_id` (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__commentbox_reactions_counters` (`comment_id`) SELECT `id` FROM `#__commentbox_comments`;

ALTER TABLE `#__commentbox_comments` ADD COLUMN `reactions` int unsigned NOT NULL DEFAULT '0' AFTER `flagged`;
ALTER TABLE `#__commentbox_comments` ADD COLUMN `votes` int unsigned NOT NULL DEFAULT '0' AFTER `reactions`;
ALTER TABLE `#__commentbox_comments` ADD COLUMN `upvotes` int unsigned NOT NULL DEFAULT '0' AFTER `votes`;
ALTER TABLE `#__commentbox_comments` ADD COLUMN `downvotes` int unsigned NOT NULL DEFAULT '0' AFTER `upvotes`;
ALTER TABLE `#__commentbox_comments` ADD COLUMN `score` int NOT NULL DEFAULT '0' AFTER `downvotes`;

ALTER TABLE `#__commentbox_comments` ADD INDEX `idx_reactions` (`reactions`);
ALTER TABLE `#__commentbox_comments` ADD INDEX `idx_votes` (`votes`);
ALTER TABLE `#__commentbox_comments` ADD INDEX `idx_upvotes` (`upvotes`);
ALTER TABLE `#__commentbox_comments` ADD INDEX `idx_downvotes` (`downvotes`);
ALTER TABLE `#__commentbox_comments` ADD INDEX `idx_score` (`score`);
