CREATE TABLE IF NOT EXISTS `#__commentbox_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `page_id` bigint unsigned NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `text` longtext NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `flagged` tinyint(1) DEFAULT NULL,
  `reactions` int unsigned NOT NULL DEFAULT '0',
  `votes` int unsigned NOT NULL DEFAULT '0',
  `upvotes` int unsigned NOT NULL DEFAULT '0',
  `downvotes` int unsigned NOT NULL DEFAULT '0',
  `score` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int NOT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_page_id` (`page_id`),
  KEY `idx_state` (`state`),
  KEY `idx_flagged` (`flagged`),
  KEY `idx_reactions` (`reactions`),
  KEY `idx_votes` (`votes`),
  KEY `idx_upvotes` (`upvotes`),
  KEY `idx_downvotes` (`downvotes`),
  KEY `idx_score` (`score`),
  KEY `idx_created` (`created` DESC),
  KEY `idx_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL,
  `comments_total` int NOT NULL DEFAULT '0',
  `comments_published` int NOT NULL DEFAULT '0',
  `comments_unpublished` int NOT NULL DEFAULT '0',
  `comments_spam` int NOT NULL DEFAULT '0',
  `comments_trashed` int NOT NULL DEFAULT '0',
  `component` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_page` (`component`,`view`,`key`),
  KEY `idx_state` (`state`),
  KEY `idx_comments_total` (`comments_total`),
  KEY `idx_comments_published` (`comments_published`),
  KEY `idx_comments_unpublished` (`comments_unpublished`),
  KEY `idx_comments_spam` (`comments_spam`),
  KEY `idx_comments_trashed` (`comments_trashed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_votes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `vote` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_user` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_reactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `reaction` tinyint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_user` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_reactions_counters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int unsigned NOT NULL,
  `like` int unsigned NOT NULL DEFAULT '0',
  `dislike` int unsigned NOT NULL DEFAULT '0',
  `love` int unsigned NOT NULL DEFAULT '0',
  `funny` int unsigned NOT NULL DEFAULT '0',
  `wow` int unsigned NOT NULL DEFAULT '0',
  `sad` int unsigned NOT NULL DEFAULT '0',
  `angry` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_comment_id` (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__commentbox_comments_flags_xref` (
  `comment_id` int NOT NULL,
  `flag_id` int NOT NULL,
  `score` float(5,3) NOT NULL,
  PRIMARY KEY (`comment_id`,`flag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__commentbox_flags` (`id`, `name`, `key`) VALUES
	('1', 'harassment', 'COM_COMMENTBOX_FLAG_HARASSMENT'),
	('2', 'threats', 'COM_COMMENTBOX_FLAG_THREATS'),
	('3', 'hate', 'COM_COMMENTBOX_FLAG_HATE'),
	('4', 'discrimination', 'COM_COMMENTBOX_FLAG_DISCRIMINATION'),
	('5', 'violence', 'COM_COMMENTBOX_FLAG_VIOLENCE'),
	('6', 'sexual', 'COM_COMMENTBOX_FLAG_SEXUAL'),
	('7', 'self-harm', 'COM_COMMENTBOX_FLAG_SELF_HARM'),
	('8', 'profanity', 'COM_COMMENTBOX_FLAG_PROFANITY'),
	('9', 'illicit', 'COM_COMMENTBOX_FLAG_ILLICIT'),
	('10', 'unsafe', 'COM_COMMENTBOX_FLAG_UNSAFE'),
	('11', 'spam', 'COM_COMMENTBOX_FLAG_SPAM'),
	('12', 'sensitive', 'COM_COMMENTBOX_FLAG_SENSITIVE'),
	('13', 'incoherent', 'COM_COMMENTBOX_FLAG_INCOHERENT'),
	('14', 'unsubstantial', 'COM_COMMENTBOX_FLAG_UNSUBSTANTIAL'),
	('15', 'text in image', 'COM_COMMENTBOX_FLAG_TEXT_IN_IMAGE');
