<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Plugin\Privacy\CommentBox\Extension;

use Joomla\CMS\Event\Privacy\ExportRequestEvent;
use Joomla\CMS\Event\Privacy\RemoveDataEvent;
use Joomla\Component\Privacy\Administrator\Plugin\PrivacyPlugin;
use Joomla\Event\SubscriberInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

final class CommentBox extends PrivacyPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onPrivacyRemoveData'    => 'onPrivacyRemoveData',
            'onPrivacyExportRequest' => 'onPrivacyExportRequest',
        ];
    }

    public function onPrivacyRemoveData(RemoveDataEvent $event)
    {
        $user = $event->getUser();

        if (!$user) {
            return;
        }

        $db    = $this->getDatabase();
        $query = $db->getQuery(true);
        $query->update($db->qn('#__commentbox_comments'))
            ->set($db->qn('text').' = '.$db->q(''))
            ->set($db->qn('name').' = '.$db->q(''))
            ->set($db->qn('email').' = '.$db->q(''))
            ->where($db->qn('created_by') . ' = ' . $db->q($user->id));
        $db->setQuery($query);
        $db->execute();
    }

    public function onPrivacyExportRequest(ExportRequestEvent $event)
    {
        $user = $event->getUser();

        if (!$user) {
            return;
        }

        $domains   = [];
        $domain    = $this->createDomain('user_comments', 'commentbox_user_comments_data');
        $domains[] = $domain;

        $db = $this->getDatabase();

        $query = $db->getQuery(true)
            ->select('*')
            ->from($db->qn('#__commentbox_comments'))
            ->where($db->qn('created_by') . ' = ' . $db->q($user->id))
            ->order($db->qn('id') . ' ASC');

        $items = $db->setQuery($query)->loadObjectList();

        foreach ($items as $item) {
            $domain->addItem($this->createItemFromArray((array) $item));
        }

        $result = $event->getArgument('result', []);
        $event->setArgument('result', array_merge($result, [$domains]));
    }
}
