<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Plugin\CommentBox\Recaptcha\Extension;

\defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;

final class Recaptcha extends CMSPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onCommentBoxCaptchaVerify' => 'onCaptchaVerify',
            'onCommentBoxCaptchaLoad'   => 'onCaptchaLoad',
        ];
    }

    public function onCaptchaVerify(Event $event): void
    {
        [$solution] = $event->getArguments();

        $params = ComponentHelper::getParams('com_commentbox');

        $data = [
            'response' => $solution,
            'secret'   => $params->get('recaptcha_secret_key'),
        ];

        $http = HttpFactory::getHttp();

        $response = $http->post('https://www.google.com/recaptcha/api/siteverify', $data);

        if ($response->code < 200 || $response->code >= 300) {
            throw new \Exception(Text::_('COM_COMMENTBOX_ERROR_COMMUNICATING_WITH_CAPTCHA_SERVICE'), 500);
        }

        $body = json_decode($response->body);

        $result = isset($body->success) && $body->success === true && isset($body->score) && $body->score >= 0.5 && isset($body->action) && $body->action === 'comment';

        $event->setArgument('result', $result);
    }

    public function onCaptchaLoad(): void
    {
        $params = ComponentHelper::getParams('com_commentbox');
        $key    = $params->get('recaptcha_site_key');

        $wa       = Factory::getDocument()->getWebAssetManager();
        $language = Factory::getLanguage()->getTag();
        $wa->registerAndUseScript('recaptcha', 'https://www.google.com/recaptcha/api.js?render='.$key.'&hl='.$language, [], ['referrerpolicy' => 'no-referrer']);
        $wa->addInlineStyle('.grecaptcha-badge { visibility: hidden; }');
    }
}
