<?php

/**
 * @author      Lefteris Kavadas
 * @copyright   Copyright (c) 2016 - 2025 Lefteris Kavadas / firecoders.com
 * @license     GNU General Public License version 3 or later
 */

namespace Firecoders\Plugin\User\CommentBox\Extension;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


final class CommentBox extends CMSPlugin implements SubscriberInterface
{
    use DatabaseAwareTrait;

    protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array
    {
        if (!ComponentHelper::isEnabled('com_commentbox')) {
            return [];
        }

        return [
            'onUserAfterDelete' => 'onUserAfterDelete',
        ];
    }

    public function onUserAfterDelete(Event $event): void
    {
        [$user, $success, $msg] = array_values($event->getArguments());

        if (!isset($user['id']) || !$user['id']) {
            return;
        }

        if (!$success) {
            return;
        }

        $db    = $this->getDatabase();
        $query = $db->getQuery(true);
        $query->update($db->qn('#__commentbox_comments'))
            ->set($db->qn('text').' = '.$db->q(''))
            ->set($db->qn('name').' = '.$db->q(''))
            ->set($db->qn('email').' = '.$db->q(''))
            ->where($db->qn('created_by') . ' = ' . $db->q($user['id']));
        $db->setQuery($query);
        $db->execute();
    }

}
